/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbv2LoadBalancerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbv2LoadBalancerDetails.Builder, AwsElbv2LoadBalancerDetails> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsElbv2LoadBalancerDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanonicalHostedZoneId").getter(getter(AwsElbv2LoadBalancerDetails::canonicalHostedZoneId))
            .setter(setter(Builder::canonicalHostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneId").build())
            .build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(AwsElbv2LoadBalancerDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DNSName").getter(getter(AwsElbv2LoadBalancerDetails::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(AwsElbv2LoadBalancerDetails::ipAddressType))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scheme")
            .getter(getter(AwsElbv2LoadBalancerDetails::scheme)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(AwsElbv2LoadBalancerDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LoadBalancerState> STATE_FIELD = SdkField.<LoadBalancerState> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(AwsElbv2LoadBalancerDetails::state)).setter(setter(Builder::state))
            .constructor(LoadBalancerState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsElbv2LoadBalancerDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsElbv2LoadBalancerDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<AwsElbv2LoadBalancerAttribute>> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField
            .<List<AwsElbv2LoadBalancerAttribute>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerAttributes")
            .getter(getter(AwsElbv2LoadBalancerDetails::loadBalancerAttributes))
            .setter(setter(Builder::loadBalancerAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElbv2LoadBalancerAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElbv2LoadBalancerAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            CANONICAL_HOSTED_ZONE_ID_FIELD, CREATED_TIME_FIELD, DNS_NAME_FIELD, IP_ADDRESS_TYPE_FIELD, SCHEME_FIELD,
            SECURITY_GROUPS_FIELD, STATE_FIELD, TYPE_FIELD, VPC_ID_FIELD, LOAD_BALANCER_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AvailabilityZone> availabilityZones;

    private final String canonicalHostedZoneId;

    private final String createdTime;

    private final String dnsName;

    private final String ipAddressType;

    private final String scheme;

    private final List<String> securityGroups;

    private final LoadBalancerState state;

    private final String type;

    private final String vpcId;

    private final List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes;

    private AwsElbv2LoadBalancerDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.dnsName = builder.dnsName;
        this.ipAddressType = builder.ipAddressType;
        this.scheme = builder.scheme;
        this.securityGroups = builder.securityGroups;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcId = builder.vpcId;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones for the load balancer.
     */
    public final List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     * </p>
     * 
     * @return The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     */
    public final String canonicalHostedZoneId() {
        return canonicalHostedZoneId;
    }

    /**
     * <p>
     * Indicates when the load balancer was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the load balancer was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The public DNS name of the load balancer.
     * </p>
     * 
     * @return The public DNS name of the load balancer.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code>
     * (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     * </p>
     * 
     * @return The type of IP addresses used by the subnets for your load balancer. The possible values are
     *         <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
     */
    public final String ipAddressType() {
        return ipAddressType;
    }

    /**
     * <p>
     * The nodes of an Internet-facing load balancer have public IP addresses.
     * </p>
     * 
     * @return The nodes of an Internet-facing load balancer have public IP addresses.
     */
    public final String scheme() {
        return scheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The IDs of the security groups for the load balancer.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The state of the load balancer.
     * </p>
     * 
     * @return The state of the load balancer.
     */
    public final LoadBalancerState state() {
        return state;
    }

    /**
     * <p>
     * The type of load balancer.
     * </p>
     * 
     * @return The type of load balancer.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the VPC for the load balancer.
     * </p>
     * 
     * @return The ID of the VPC for the load balancer.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLoadBalancerAttributes() {
        return loadBalancerAttributes != null && !(loadBalancerAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes of the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerAttributes} method.
     * </p>
     * 
     * @return Attributes of the load balancer.
     */
    public final List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes() {
        return loadBalancerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(scheme());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerAttributes() ? loadBalancerAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbv2LoadBalancerDetails)) {
            return false;
        }
        AwsElbv2LoadBalancerDetails other = (AwsElbv2LoadBalancerDetails) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(canonicalHostedZoneId(), other.canonicalHostedZoneId())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(ipAddressType(), other.ipAddressType()) && Objects.equals(scheme(), other.scheme())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(state(), other.state()) && Objects.equals(type(), other.type())
                && Objects.equals(vpcId(), other.vpcId()) && hasLoadBalancerAttributes() == other.hasLoadBalancerAttributes()
                && Objects.equals(loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbv2LoadBalancerDetails")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("CanonicalHostedZoneId", canonicalHostedZoneId()).add("CreatedTime", createdTime())
                .add("DNSName", dnsName()).add("IpAddressType", ipAddressType()).add("Scheme", scheme())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("State", state()).add("Type", type())
                .add("VpcId", vpcId())
                .add("LoadBalancerAttributes", hasLoadBalancerAttributes() ? loadBalancerAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "CanonicalHostedZoneId":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DNSName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressType()));
        case "Scheme":
            return Optional.ofNullable(clazz.cast(scheme()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "LoadBalancerAttributes":
            return Optional.ofNullable(clazz.cast(loadBalancerAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbv2LoadBalancerDetails, T> g) {
        return obj -> g.apply((AwsElbv2LoadBalancerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbv2LoadBalancerDetails> {
        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AvailabilityZone.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.AvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AvailabilityZone.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(java.util.Collection<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         * </p>
         * 
         * @param canonicalHostedZoneId
         *        The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneId(String canonicalHostedZoneId);

        /**
         * <p>
         * Indicates when the load balancer was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdTime
         *        Indicates when the load balancer was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The public DNS name of the load balancer.
         * </p>
         * 
         * @param dnsName
         *        The public DNS name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The type of IP addresses used by the subnets for your load balancer. The possible values are
         * <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP addresses used by the subnets for your load balancer. The possible values are
         *        <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The nodes of an Internet-facing load balancer have public IP addresses.
         * </p>
         * 
         * @param scheme
         *        The nodes of an Internet-facing load balancer have public IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * The IDs of the security groups for the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups for the load balancer.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The state of the load balancer.
         * </p>
         * 
         * @param state
         *        The state of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(LoadBalancerState state);

        /**
         * <p>
         * The state of the load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancerState.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadBalancerState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(LoadBalancerState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link LoadBalancerState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(LoadBalancerState)
         */
        default Builder state(Consumer<LoadBalancerState.Builder> state) {
            return state(LoadBalancerState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The type of load balancer.
         * </p>
         * 
         * @param type
         *        The type of load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The ID of the VPC for the load balancer.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Attributes of the load balancer.
         * </p>
         * 
         * @param loadBalancerAttributes
         *        Attributes of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes);

        /**
         * <p>
         * Attributes of the load balancer.
         * </p>
         * 
         * @param loadBalancerAttributes
         *        Attributes of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAttributes(AwsElbv2LoadBalancerAttribute... loadBalancerAttributes);

        /**
         * <p>
         * Attributes of the load balancer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #loadBalancerAttributes(List<AwsElbv2LoadBalancerAttribute>)}.
         * 
         * @param loadBalancerAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAttributes(java.util.Collection<AwsElbv2LoadBalancerAttribute>)
         */
        Builder loadBalancerAttributes(Consumer<AwsElbv2LoadBalancerAttribute.Builder>... loadBalancerAttributes);
    }

    static final class BuilderImpl implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String canonicalHostedZoneId;

        private String createdTime;

        private String dnsName;

        private String ipAddressType;

        private String scheme;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private LoadBalancerState state;

        private String type;

        private String vpcId;

        private List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbv2LoadBalancerDetails model) {
            availabilityZones(model.availabilityZones);
            canonicalHostedZoneId(model.canonicalHostedZoneId);
            createdTime(model.createdTime);
            dnsName(model.dnsName);
            ipAddressType(model.ipAddressType);
            scheme(model.scheme);
            securityGroups(model.securityGroups);
            state(model.state);
            type(model.type);
            vpcId(model.vpcId);
            loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCanonicalHostedZoneId() {
            return canonicalHostedZoneId;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final String getScheme() {
            return scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final LoadBalancerState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(LoadBalancerState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AwsElbv2LoadBalancerAttribute.Builder> getLoadBalancerAttributes() {
            List<AwsElbv2LoadBalancerAttribute.Builder> result = AwsElbv2LoadBalancerAttributesCopier
                    .copyToBuilder(this.loadBalancerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute.BuilderImpl> loadBalancerAttributes) {
            this.loadBalancerAttributes = AwsElbv2LoadBalancerAttributesCopier.copyFromBuilder(loadBalancerAttributes);
        }

        @Override
        public final Builder loadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes) {
            this.loadBalancerAttributes = AwsElbv2LoadBalancerAttributesCopier.copy(loadBalancerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAttributes(AwsElbv2LoadBalancerAttribute... loadBalancerAttributes) {
            loadBalancerAttributes(Arrays.asList(loadBalancerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAttributes(Consumer<AwsElbv2LoadBalancerAttribute.Builder>... loadBalancerAttributes) {
            loadBalancerAttributes(Stream.of(loadBalancerAttributes)
                    .map(c -> AwsElbv2LoadBalancerAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsElbv2LoadBalancerDetails build() {
            return new AwsElbv2LoadBalancerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
