/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a data volume that's used in a task definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskVolumeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsTaskVolumeDetails.Builder, AwsEcsTaskVolumeDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsTaskVolumeDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsEcsTaskVolumeHostDetails> HOST_FIELD = SdkField
            .<AwsEcsTaskVolumeHostDetails> builder(MarshallingType.SDK_POJO).memberName("Host")
            .getter(getter(AwsEcsTaskVolumeDetails::host)).setter(setter(Builder::host))
            .constructor(AwsEcsTaskVolumeHostDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final AwsEcsTaskVolumeHostDetails host;

    private AwsEcsTaskVolumeDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.host = builder.host;
    }

    /**
     * <p>
     * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
     * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     * <code>mountPoints</code>.
     * </p>
     * 
     * @return The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
     *         are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     *         <code>mountPoints</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This parameter is specified when you use bind mount host volumes. The contents of the <code>host</code> parameter
     * determine whether your bind mount host volume persists on the host container instance and where it's stored.
     * </p>
     * 
     * @return This parameter is specified when you use bind mount host volumes. The contents of the <code>host</code>
     *         parameter determine whether your bind mount host volume persists on the host container instance and where
     *         it's stored.
     */
    public final AwsEcsTaskVolumeHostDetails host() {
        return host;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskVolumeDetails)) {
            return false;
        }
        AwsEcsTaskVolumeDetails other = (AwsEcsTaskVolumeDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(host(), other.host());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskVolumeDetails").add("Name", name()).add("Host", host()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskVolumeDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskVolumeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskVolumeDetails> {
        /**
         * <p>
         * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
         * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
         * <code>mountPoints</code>.
         * </p>
         * 
         * @param name
         *        The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
         *        are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container
         *        definition <code>mountPoints</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This parameter is specified when you use bind mount host volumes. The contents of the <code>host</code>
         * parameter determine whether your bind mount host volume persists on the host container instance and where
         * it's stored.
         * </p>
         * 
         * @param host
         *        This parameter is specified when you use bind mount host volumes. The contents of the
         *        <code>host</code> parameter determine whether your bind mount host volume persists on the host
         *        container instance and where it's stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(AwsEcsTaskVolumeHostDetails host);

        /**
         * <p>
         * This parameter is specified when you use bind mount host volumes. The contents of the <code>host</code>
         * parameter determine whether your bind mount host volume persists on the host container instance and where
         * it's stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsTaskVolumeHostDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcsTaskVolumeHostDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsTaskVolumeHostDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #host(AwsEcsTaskVolumeHostDetails)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link AwsEcsTaskVolumeHostDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(AwsEcsTaskVolumeHostDetails)
         */
        default Builder host(Consumer<AwsEcsTaskVolumeHostDetails.Builder> host) {
            return host(AwsEcsTaskVolumeHostDetails.builder().applyMutation(host).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private AwsEcsTaskVolumeHostDetails host;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskVolumeDetails model) {
            name(model.name);
            host(model.host);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsEcsTaskVolumeHostDetails.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        public final void setHost(AwsEcsTaskVolumeHostDetails.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        public final Builder host(AwsEcsTaskVolumeHostDetails host) {
            this.host = host;
            return this;
        }

        @Override
        public AwsEcsTaskVolumeDetails build() {
            return new AwsEcsTaskVolumeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
