/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.Invitation;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;

public class ListInvitationsIterable
implements SdkIterable<ListInvitationsResponse> {
    private final SecurityHubClient client;
    private final ListInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvitationsIterable(SecurityHubClient client, ListInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public Iterator<ListInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Invitation> invitations() {
        Function<ListInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invitations() != null) {
                return response.invitations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvitationsResponseFetcher
    implements SyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvitationsResponse nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsIterable.this.client.listInvitations(ListInvitationsIterable.this.firstRequest);
            }
            return ListInvitationsIterable.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

