/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UnprocessedErrorCode {
    INVALID_INPUT("INVALID_INPUT"),
    ACCESS_DENIED("ACCESS_DENIED"),
    NOT_FOUND("NOT_FOUND"),
    LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnprocessedErrorCode> VALUE_MAP;
    private final String value;

    private UnprocessedErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UnprocessedErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UnprocessedErrorCode> knownValues() {
        EnumSet<UnprocessedErrorCode> knownValues = EnumSet.allOf(UnprocessedErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UnprocessedErrorCode.class, UnprocessedErrorCode::toString);
    }
}

