/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AssociationSetDetails;
import software.amazon.awssdk.services.securityhub.model.AssociationSetListCopier;
import software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails;
import software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetListCopier;
import software.amazon.awssdk.services.securityhub.model.RouteSetDetails;
import software.amazon.awssdk.services.securityhub.model.RouteSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2RouteTableDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2RouteTableDetails> {
    private static final SdkField<List<AssociationSetDetails>> ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationSet").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::associationSet)).setter(AwsEc2RouteTableDetails.setter(Builder::associationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationSetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::ownerId)).setter(AwsEc2RouteTableDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<List<PropagatingVgwSetDetails>> PROPAGATING_VGW_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropagatingVgwSet").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::propagatingVgwSet)).setter(AwsEc2RouteTableDetails.setter(Builder::propagatingVgwSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagatingVgwSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropagatingVgwSetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::routeTableId)).setter(AwsEc2RouteTableDetails.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<List<RouteSetDetails>> ROUTE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteSet").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::routeSet)).setter(AwsEc2RouteTableDetails.setter(Builder::routeSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteSetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsEc2RouteTableDetails.getter(AwsEc2RouteTableDetails::vpcId)).setter(AwsEc2RouteTableDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_SET_FIELD, OWNER_ID_FIELD, PROPAGATING_VGW_SET_FIELD, ROUTE_TABLE_ID_FIELD, ROUTE_SET_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AssociationSetDetails> associationSet;
    private final String ownerId;
    private final List<PropagatingVgwSetDetails> propagatingVgwSet;
    private final String routeTableId;
    private final List<RouteSetDetails> routeSet;
    private final String vpcId;

    private AwsEc2RouteTableDetails(BuilderImpl builder) {
        this.associationSet = builder.associationSet;
        this.ownerId = builder.ownerId;
        this.propagatingVgwSet = builder.propagatingVgwSet;
        this.routeTableId = builder.routeTableId;
        this.routeSet = builder.routeSet;
        this.vpcId = builder.vpcId;
    }

    public final boolean hasAssociationSet() {
        return this.associationSet != null && !(this.associationSet instanceof SdkAutoConstructList);
    }

    public final List<AssociationSetDetails> associationSet() {
        return this.associationSet;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasPropagatingVgwSet() {
        return this.propagatingVgwSet != null && !(this.propagatingVgwSet instanceof SdkAutoConstructList);
    }

    public final List<PropagatingVgwSetDetails> propagatingVgwSet() {
        return this.propagatingVgwSet;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final boolean hasRouteSet() {
        return this.routeSet != null && !(this.routeSet instanceof SdkAutoConstructList);
    }

    public final List<RouteSetDetails> routeSet() {
        return this.routeSet;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationSet() ? this.associationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropagatingVgwSet() ? this.propagatingVgwSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteSet() ? this.routeSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2RouteTableDetails)) {
            return false;
        }
        AwsEc2RouteTableDetails other = (AwsEc2RouteTableDetails)obj;
        return this.hasAssociationSet() == other.hasAssociationSet() && Objects.equals(this.associationSet(), other.associationSet()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasPropagatingVgwSet() == other.hasPropagatingVgwSet() && Objects.equals(this.propagatingVgwSet(), other.propagatingVgwSet()) && Objects.equals(this.routeTableId(), other.routeTableId()) && this.hasRouteSet() == other.hasRouteSet() && Objects.equals(this.routeSet(), other.routeSet()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2RouteTableDetails").add("AssociationSet", this.hasAssociationSet() ? this.associationSet() : null).add("OwnerId", (Object)this.ownerId()).add("PropagatingVgwSet", this.hasPropagatingVgwSet() ? this.propagatingVgwSet() : null).add("RouteTableId", (Object)this.routeTableId()).add("RouteSet", this.hasRouteSet() ? this.routeSet() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationSet": {
                return Optional.ofNullable(clazz.cast(this.associationSet()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PropagatingVgwSet": {
                return Optional.ofNullable(clazz.cast(this.propagatingVgwSet()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "RouteSet": {
                return Optional.ofNullable(clazz.cast(this.routeSet()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2RouteTableDetails, T> g) {
        return obj -> g.apply((AwsEc2RouteTableDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssociationSetDetails> associationSet = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private List<PropagatingVgwSetDetails> propagatingVgwSet = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;
        private List<RouteSetDetails> routeSet = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2RouteTableDetails model) {
            this.associationSet(model.associationSet);
            this.ownerId(model.ownerId);
            this.propagatingVgwSet(model.propagatingVgwSet);
            this.routeTableId(model.routeTableId);
            this.routeSet(model.routeSet);
            this.vpcId(model.vpcId);
        }

        public final List<AssociationSetDetails.Builder> getAssociationSet() {
            List<AssociationSetDetails.Builder> result = AssociationSetListCopier.copyToBuilder(this.associationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationSet(Collection<AssociationSetDetails.BuilderImpl> associationSet) {
            this.associationSet = AssociationSetListCopier.copyFromBuilder(associationSet);
        }

        @Override
        public final Builder associationSet(Collection<AssociationSetDetails> associationSet) {
            this.associationSet = AssociationSetListCopier.copy(associationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSet(AssociationSetDetails ... associationSet) {
            this.associationSet(Arrays.asList(associationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSet(Consumer<AssociationSetDetails.Builder> ... associationSet) {
            this.associationSet(Stream.of(associationSet).map(c -> (AssociationSetDetails)((AssociationSetDetails.Builder)AssociationSetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<PropagatingVgwSetDetails.Builder> getPropagatingVgwSet() {
            List<PropagatingVgwSetDetails.Builder> result = PropagatingVgwSetListCopier.copyToBuilder(this.propagatingVgwSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropagatingVgwSet(Collection<PropagatingVgwSetDetails.BuilderImpl> propagatingVgwSet) {
            this.propagatingVgwSet = PropagatingVgwSetListCopier.copyFromBuilder(propagatingVgwSet);
        }

        @Override
        public final Builder propagatingVgwSet(Collection<PropagatingVgwSetDetails> propagatingVgwSet) {
            this.propagatingVgwSet = PropagatingVgwSetListCopier.copy(propagatingVgwSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgwSet(PropagatingVgwSetDetails ... propagatingVgwSet) {
            this.propagatingVgwSet(Arrays.asList(propagatingVgwSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgwSet(Consumer<PropagatingVgwSetDetails.Builder> ... propagatingVgwSet) {
            this.propagatingVgwSet(Stream.of(propagatingVgwSet).map(c -> (PropagatingVgwSetDetails)((PropagatingVgwSetDetails.Builder)PropagatingVgwSetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<RouteSetDetails.Builder> getRouteSet() {
            List<RouteSetDetails.Builder> result = RouteSetListCopier.copyToBuilder(this.routeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteSet(Collection<RouteSetDetails.BuilderImpl> routeSet) {
            this.routeSet = RouteSetListCopier.copyFromBuilder(routeSet);
        }

        @Override
        public final Builder routeSet(Collection<RouteSetDetails> routeSet) {
            this.routeSet = RouteSetListCopier.copy(routeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSet(RouteSetDetails ... routeSet) {
            this.routeSet(Arrays.asList(routeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSet(Consumer<RouteSetDetails.Builder> ... routeSet) {
            this.routeSet(Stream.of(routeSet).map(c -> (RouteSetDetails)((RouteSetDetails.Builder)RouteSetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public AwsEc2RouteTableDetails build() {
            return new AwsEc2RouteTableDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2RouteTableDetails> {
        public Builder associationSet(Collection<AssociationSetDetails> var1);

        public Builder associationSet(AssociationSetDetails ... var1);

        public Builder associationSet(Consumer<AssociationSetDetails.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder propagatingVgwSet(Collection<PropagatingVgwSetDetails> var1);

        public Builder propagatingVgwSet(PropagatingVgwSetDetails ... var1);

        public Builder propagatingVgwSet(Consumer<PropagatingVgwSetDetails.Builder> ... var1);

        public Builder routeTableId(String var1);

        public Builder routeSet(Collection<RouteSetDetails> var1);

        public Builder routeSet(RouteSetDetails ... var1);

        public Builder routeSet(Consumer<RouteSetDetails.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

