/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> {
    private static final SdkField<List<Integer>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes::items)).setter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes::quantity)).setter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, QUANTITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Integer> items;
    private final Integer quantity;

    private AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(BuilderImpl builder) {
        this.items = builder.items;
        this.quantity = builder.quantity;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<Integer> items() {
        return this.items;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)) {
            return false;
        }
        AwsCloudFrontDistributionOriginGroupFailoverStatusCodes other = (AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)obj;
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.quantity(), other.quantity());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionOriginGroupFailoverStatusCodes").add("Items", this.hasItems() ? this.items() : null).add("Quantity", (Object)this.quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> items = DefaultSdkAutoConstructList.getInstance();
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes model) {
            this.items(model.items);
            this.quantity(model.quantity);
        }

        public final Collection<Integer> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items;
        }

        public final void setItems(Collection<Integer> items) {
            this.items = AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemListCopier.copy(items);
        }

        @Override
        public final Builder items(Collection<Integer> items) {
            this.items = AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Integer ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public AwsCloudFrontDistributionOriginGroupFailoverStatusCodes build() {
            return new AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> {
        public Builder items(Collection<Integer> var1);

        public Builder items(Integer ... var1);

        public Builder quantity(Integer var1);
    }
}

