/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> {
    private static final SdkField<List<String>> FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Flags").getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags::flags)).setter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.setter(Builder::flags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Masks").getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.getter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags::masks)).setter(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.setter(Builder::masks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Masks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAGS_FIELD, MASKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> flags;
    private final List<String> masks;

    private RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(BuilderImpl builder) {
        this.flags = builder.flags;
        this.masks = builder.masks;
    }

    public final boolean hasFlags() {
        return this.flags != null && !(this.flags instanceof SdkAutoConstructList);
    }

    public final List<String> flags() {
        return this.flags;
    }

    public final boolean hasMasks() {
        return this.masks != null && !(this.masks instanceof SdkAutoConstructList);
    }

    public final List<String> masks() {
        return this.masks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlags() ? this.flags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMasks() ? this.masks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleMatchAttributesTcpFlags)) {
            return false;
        }
        RuleGroupSourceStatelessRuleMatchAttributesTcpFlags other = (RuleGroupSourceStatelessRuleMatchAttributesTcpFlags)obj;
        return this.hasFlags() == other.hasFlags() && Objects.equals(this.flags(), other.flags()) && this.hasMasks() == other.hasMasks() && Objects.equals(this.masks(), other.masks());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSourceStatelessRuleMatchAttributesTcpFlags").add("Flags", this.hasFlags() ? this.flags() : null).add("Masks", this.hasMasks() ? this.masks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flags": {
                return Optional.ofNullable(clazz.cast(this.flags()));
            }
            case "Masks": {
                return Optional.ofNullable(clazz.cast(this.masks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleMatchAttributesTcpFlags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> flags = DefaultSdkAutoConstructList.getInstance();
        private List<String> masks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags model) {
            this.flags(model.flags);
            this.masks(model.masks);
        }

        public final Collection<String> getFlags() {
            if (this.flags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.flags;
        }

        public final void setFlags(Collection<String> flags) {
            this.flags = NonEmptyStringListCopier.copy(flags);
        }

        @Override
        public final Builder flags(Collection<String> flags) {
            this.flags = NonEmptyStringListCopier.copy(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flags(String ... flags) {
            this.flags(Arrays.asList(flags));
            return this;
        }

        public final Collection<String> getMasks() {
            if (this.masks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.masks;
        }

        public final void setMasks(Collection<String> masks) {
            this.masks = NonEmptyStringListCopier.copy(masks);
        }

        @Override
        public final Builder masks(Collection<String> masks) {
            this.masks = NonEmptyStringListCopier.copy(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masks(String ... masks) {
            this.masks(Arrays.asList(masks));
            return this;
        }

        public RuleGroupSourceStatelessRuleMatchAttributesTcpFlags build() {
            return new RuleGroupSourceStatelessRuleMatchAttributesTcpFlags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> {
        public Builder flags(Collection<String> var1);

        public Builder flags(String ... var1);

        public Builder masks(Collection<String> var1);

        public Builder masks(String ... var1);
    }
}

