/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse;
import software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition;

public class ListSecurityControlDefinitionsIterable
implements SdkIterable<ListSecurityControlDefinitionsResponse> {
    private final SecurityHubClient client;
    private final ListSecurityControlDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityControlDefinitionsIterable(SecurityHubClient client, ListSecurityControlDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityControlDefinitionsResponseFetcher();
    }

    public Iterator<ListSecurityControlDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityControlDefinition> securityControlDefinitions() {
        Function<ListSecurityControlDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityControlDefinitions() != null) {
                return response.securityControlDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityControlDefinitionsResponseFetcher
    implements SyncPageFetcher<ListSecurityControlDefinitionsResponse> {
        private ListSecurityControlDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityControlDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityControlDefinitionsResponse nextPage(ListSecurityControlDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityControlDefinitionsIterable.this.client.listSecurityControlDefinitions(ListSecurityControlDefinitionsIterable.this.firstRequest);
            }
            return ListSecurityControlDefinitionsIterable.this.client.listSecurityControlDefinitions((ListSecurityControlDefinitionsRequest)((Object)ListSecurityControlDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

