/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThreatIntelIndicatorCategory {
    BACKDOOR("BACKDOOR"),
    CARD_STEALER("CARD_STEALER"),
    COMMAND_AND_CONTROL("COMMAND_AND_CONTROL"),
    DROP_SITE("DROP_SITE"),
    EXPLOIT_SITE("EXPLOIT_SITE"),
    KEYLOGGER("KEYLOGGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThreatIntelIndicatorCategory> VALUE_MAP;
    private final String value;

    private ThreatIntelIndicatorCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreatIntelIndicatorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThreatIntelIndicatorCategory> knownValues() {
        EnumSet<ThreatIntelIndicatorCategory> knownValues = EnumSet.allOf(ThreatIntelIndicatorCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThreatIntelIndicatorCategory.class, ThreatIntelIndicatorCategory::toString);
    }
}

