/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatusReasonCode {
    NO_AVAILABLE_CONFIGURATION_RECORDER("NO_AVAILABLE_CONFIGURATION_RECORDER"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatusReasonCode> VALUE_MAP;
    private final String value;

    private StatusReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusReasonCode> knownValues() {
        EnumSet<StatusReasonCode> knownValues = EnumSet.allOf(StatusReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatusReasonCode.class, StatusReasonCode::toString);
    }
}

