/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpnConnectionOptionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpnConnectionOptionsDetails> {
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StaticRoutesOnly").getter(AwsEc2VpnConnectionOptionsDetails.getter(AwsEc2VpnConnectionOptionsDetails::staticRoutesOnly)).setter(AwsEc2VpnConnectionOptionsDetails.setter(Builder::staticRoutesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").build()}).build();
    private static final SdkField<List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TunnelOptions").getter(AwsEc2VpnConnectionOptionsDetails.getter(AwsEc2VpnConnectionOptionsDetails::tunnelOptions)).setter(AwsEc2VpnConnectionOptionsDetails.setter(Builder::tunnelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_ROUTES_ONLY_FIELD, TUNNEL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean staticRoutesOnly;
    private final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions;

    private AwsEc2VpnConnectionOptionsDetails(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    public final Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public final boolean hasTunnelOptions() {
        return this.tunnelOptions != null && !(this.tunnelOptions instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions() {
        return this.tunnelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTunnelOptions() ? this.tunnelOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionOptionsDetails)) {
            return false;
        }
        AwsEc2VpnConnectionOptionsDetails other = (AwsEc2VpnConnectionOptionsDetails)obj;
        return Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && this.hasTunnelOptions() == other.hasTunnelOptions() && Objects.equals(this.tunnelOptions(), other.tunnelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpnConnectionOptionsDetails").add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("TunnelOptions", this.hasTunnelOptions() ? this.tunnelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticRoutesOnly": {
                return Optional.ofNullable(clazz.cast(this.staticRoutesOnly()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionOptionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean staticRoutesOnly;
        private List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionOptionsDetails model) {
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> getTunnelOptions() {
            List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> result = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier.copyToBuilder(this.tunnelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public final Builder tunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions) {
            this.tunnelOptions = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(AwsEc2VpnConnectionOptionsTunnelOptionsDetails ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> ... tunnelOptions) {
            this.tunnelOptions(Stream.of(tunnelOptions).map(c -> (AwsEc2VpnConnectionOptionsTunnelOptionsDetails)((AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder)AwsEc2VpnConnectionOptionsTunnelOptionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEc2VpnConnectionOptionsDetails build() {
            return new AwsEc2VpnConnectionOptionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpnConnectionOptionsDetails> {
        public Builder staticRoutesOnly(Boolean var1);

        public Builder tunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> var1);

        public Builder tunnelOptions(AwsEc2VpnConnectionOptionsTunnelOptionsDetails ... var1);

        public Builder tunnelOptions(Consumer<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> ... var1);
    }
}

