/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.SchemasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemasRequest
extends SchemasRequest
implements ToCopyableBuilder<Builder, ListSchemasRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListSchemasRequest.getter(ListSchemasRequest::limit)).setter(ListSchemasRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSchemasRequest.getter(ListSchemasRequest::nextToken)).setter(ListSchemasRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(ListSchemasRequest.getter(ListSchemasRequest::registryName)).setter(ListSchemasRequest.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaNamePrefix").getter(ListSchemasRequest.getter(ListSchemasRequest::schemaNamePrefix)).setter(ListSchemasRequest.setter(Builder::schemaNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("schemaNamePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, NEXT_TOKEN_FIELD, REGISTRY_NAME_FIELD, SCHEMA_NAME_PREFIX_FIELD));
    private final Integer limit;
    private final String nextToken;
    private final String registryName;
    private final String schemaNamePrefix;

    private ListSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.registryName = builder.registryName;
        this.schemaNamePrefix = builder.schemaNamePrefix;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String registryName() {
        return this.registryName;
    }

    public final String schemaNamePrefix() {
        return this.schemaNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaNamePrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasRequest)) {
            return false;
        }
        ListSchemasRequest other = (ListSchemasRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.schemaNamePrefix(), other.schemaNamePrefix());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchemasRequest").add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).add("RegistryName", (Object)this.registryName()).add("SchemaNamePrefix", (Object)this.schemaNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "SchemaNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.schemaNamePrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasRequest, T> g) {
        return obj -> g.apply((ListSchemasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String nextToken;
        private String registryName;
        private String schemaNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasRequest model) {
            super(model);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
            this.registryName(model.registryName);
            this.schemaNamePrefix(model.schemaNamePrefix);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaNamePrefix() {
            return this.schemaNamePrefix;
        }

        public final void setSchemaNamePrefix(String schemaNamePrefix) {
            this.schemaNamePrefix = schemaNamePrefix;
        }

        @Override
        public final Builder schemaNamePrefix(String schemaNamePrefix) {
            this.schemaNamePrefix = schemaNamePrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchemasRequest build() {
            return new ListSchemasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemasRequest> {
        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder registryName(String var1);

        public Builder schemaNamePrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

