/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInferenceExperimentRequest extends SageMakerRequest implements
        ToCopyableBuilder<StopInferenceExperimentRequest.Builder, StopInferenceExperimentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StopInferenceExperimentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> MODEL_VARIANT_ACTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ModelVariantActions")
            .getter(getter(StopInferenceExperimentRequest::modelVariantActionsAsStrings))
            .setter(setter(Builder::modelVariantActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariantActions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ModelVariantConfig>> DESIRED_MODEL_VARIANTS_FIELD = SdkField
            .<List<ModelVariantConfig>> builder(MarshallingType.LIST)
            .memberName("DesiredModelVariants")
            .getter(getter(StopInferenceExperimentRequest::desiredModelVariants))
            .setter(setter(Builder::desiredModelVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVariantConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVariantConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(StopInferenceExperimentRequest::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(StopInferenceExperimentRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MODEL_VARIANT_ACTIONS_FIELD, DESIRED_MODEL_VARIANTS_FIELD, DESIRED_STATE_FIELD, REASON_FIELD));

    private final String name;

    private final Map<String, String> modelVariantActions;

    private final List<ModelVariantConfig> desiredModelVariants;

    private final String desiredState;

    private final String reason;

    private StopInferenceExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.modelVariantActions = builder.modelVariantActions;
        this.desiredModelVariants = builder.desiredModelVariants;
        this.desiredState = builder.desiredState;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of the inference experiment to stop.
     * </p>
     * 
     * @return The name of the inference experiment to stop.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Array of key-value pairs, with names of variants mapped to actions. The possible actions are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Promote</code> - Promote the shadow variant to a production variant
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Remove</code> - Delete the variant
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Retain</code> - Keep the variant as it is
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVariantActions} method.
     * </p>
     * 
     * @return Array of key-value pairs, with names of variants mapped to actions. The possible actions are the
     *         following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Promote</code> - Promote the shadow variant to a production variant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Remove</code> - Delete the variant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Retain</code> - Keep the variant as it is
     *         </p>
     *         </li>
     */
    public final Map<String, ModelVariantAction> modelVariantActions() {
        return ModelVariantActionMapCopier.copyStringToEnum(modelVariantActions);
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVariantActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVariantActions() {
        return modelVariantActions != null && !(modelVariantActions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of key-value pairs, with names of variants mapped to actions. The possible actions are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Promote</code> - Promote the shadow variant to a production variant
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Remove</code> - Delete the variant
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Retain</code> - Keep the variant as it is
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVariantActions} method.
     * </p>
     * 
     * @return Array of key-value pairs, with names of variants mapped to actions. The possible actions are the
     *         following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Promote</code> - Promote the shadow variant to a production variant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Remove</code> - Delete the variant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Retain</code> - Keep the variant as it is
     *         </p>
     *         </li>
     */
    public final Map<String, String> modelVariantActionsAsStrings() {
        return modelVariantActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DesiredModelVariants property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDesiredModelVariants() {
        return desiredModelVariants != null && !(desiredModelVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to deploy after
     * the inference experiment stops. Each <code>ModelVariantConfig</code> describes the infrastructure configuration
     * for deploying the corresponding variant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDesiredModelVariants} method.
     * </p>
     * 
     * @return An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to
     *         deploy after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the
     *         infrastructure configuration for deploying the corresponding variant.
     */
    public final List<ModelVariantConfig> desiredModelVariants() {
        return desiredModelVariants;
    }

    /**
     * <p>
     * The desired state of the experiment after stopping. The possible states are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The experiment completed successfully
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code>: The experiment was canceled
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link InferenceExperimentStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the experiment after stopping. The possible states are the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The experiment completed successfully
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code>: The experiment was canceled
     *         </p>
     *         </li>
     * @see InferenceExperimentStopDesiredState
     */
    public final InferenceExperimentStopDesiredState desiredState() {
        return InferenceExperimentStopDesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * The desired state of the experiment after stopping. The possible states are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The experiment completed successfully
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code>: The experiment was canceled
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link InferenceExperimentStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the experiment after stopping. The possible states are the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The experiment completed successfully
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code>: The experiment was canceled
     *         </p>
     *         </li>
     * @see InferenceExperimentStopDesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The reason for stopping the experiment.
     * </p>
     * 
     * @return The reason for stopping the experiment.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVariantActions() ? modelVariantActionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDesiredModelVariants() ? desiredModelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInferenceExperimentRequest)) {
            return false;
        }
        StopInferenceExperimentRequest other = (StopInferenceExperimentRequest) obj;
        return Objects.equals(name(), other.name()) && hasModelVariantActions() == other.hasModelVariantActions()
                && Objects.equals(modelVariantActionsAsStrings(), other.modelVariantActionsAsStrings())
                && hasDesiredModelVariants() == other.hasDesiredModelVariants()
                && Objects.equals(desiredModelVariants(), other.desiredModelVariants())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopInferenceExperimentRequest").add("Name", name())
                .add("ModelVariantActions", hasModelVariantActions() ? modelVariantActionsAsStrings() : null)
                .add("DesiredModelVariants", hasDesiredModelVariants() ? desiredModelVariants() : null)
                .add("DesiredState", desiredStateAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ModelVariantActions":
            return Optional.ofNullable(clazz.cast(modelVariantActionsAsStrings()));
        case "DesiredModelVariants":
            return Optional.ofNullable(clazz.cast(desiredModelVariants()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopInferenceExperimentRequest, T> g) {
        return obj -> g.apply((StopInferenceExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopInferenceExperimentRequest> {
        /**
         * <p>
         * The name of the inference experiment to stop.
         * </p>
         * 
         * @param name
         *        The name of the inference experiment to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Array of key-value pairs, with names of variants mapped to actions. The possible actions are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Promote</code> - Promote the shadow variant to a production variant
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Remove</code> - Delete the variant
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Retain</code> - Keep the variant as it is
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelVariantActions
         *        Array of key-value pairs, with names of variants mapped to actions. The possible actions are the
         *        following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Promote</code> - Promote the shadow variant to a production variant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Remove</code> - Delete the variant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Retain</code> - Keep the variant as it is
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariantActionsWithStrings(Map<String, String> modelVariantActions);

        /**
         * <p>
         * Array of key-value pairs, with names of variants mapped to actions. The possible actions are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Promote</code> - Promote the shadow variant to a production variant
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Remove</code> - Delete the variant
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Retain</code> - Keep the variant as it is
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelVariantActions
         *        Array of key-value pairs, with names of variants mapped to actions. The possible actions are the
         *        following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Promote</code> - Promote the shadow variant to a production variant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Remove</code> - Delete the variant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Retain</code> - Keep the variant as it is
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariantActions(Map<String, ModelVariantAction> modelVariantActions);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to deploy
         * after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * 
         * @param desiredModelVariants
         *        An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to
         *        deploy after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the
         *        infrastructure configuration for deploying the corresponding variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelVariants(Collection<ModelVariantConfig> desiredModelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to deploy
         * after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * 
         * @param desiredModelVariants
         *        An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to
         *        deploy after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the
         *        infrastructure configuration for deploying the corresponding variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelVariants(ModelVariantConfig... desiredModelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to deploy
         * after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #desiredModelVariants(List<ModelVariantConfig>)}.
         * 
         * @param desiredModelVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredModelVariants(java.util.Collection<ModelVariantConfig>)
         */
        Builder desiredModelVariants(Consumer<ModelVariantConfig.Builder>... desiredModelVariants);

        /**
         * <p>
         * The desired state of the experiment after stopping. The possible states are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The experiment completed successfully
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code>: The experiment was canceled
         * </p>
         * </li>
         * </ul>
         * 
         * @param desiredState
         *        The desired state of the experiment after stopping. The possible states are the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The experiment completed successfully
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code>: The experiment was canceled
         *        </p>
         *        </li>
         * @see InferenceExperimentStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStopDesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The desired state of the experiment after stopping. The possible states are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The experiment completed successfully
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code>: The experiment was canceled
         * </p>
         * </li>
         * </ul>
         * 
         * @param desiredState
         *        The desired state of the experiment after stopping. The possible states are the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The experiment completed successfully
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code>: The experiment was canceled
         *        </p>
         *        </li>
         * @see InferenceExperimentStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStopDesiredState
         */
        Builder desiredState(InferenceExperimentStopDesiredState desiredState);

        /**
         * <p>
         * The reason for stopping the experiment.
         * </p>
         * 
         * @param reason
         *        The reason for stopping the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String name;

        private Map<String, String> modelVariantActions = DefaultSdkAutoConstructMap.getInstance();

        private List<ModelVariantConfig> desiredModelVariants = DefaultSdkAutoConstructList.getInstance();

        private String desiredState;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInferenceExperimentRequest model) {
            super(model);
            name(model.name);
            modelVariantActionsWithStrings(model.modelVariantActions);
            desiredModelVariants(model.desiredModelVariants);
            desiredState(model.desiredState);
            reason(model.reason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getModelVariantActions() {
            if (modelVariantActions instanceof SdkAutoConstructMap) {
                return null;
            }
            return modelVariantActions;
        }

        public final void setModelVariantActions(Map<String, String> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copy(modelVariantActions);
        }

        @Override
        public final Builder modelVariantActionsWithStrings(Map<String, String> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copy(modelVariantActions);
            return this;
        }

        @Override
        public final Builder modelVariantActions(Map<String, ModelVariantAction> modelVariantActions) {
            this.modelVariantActions = ModelVariantActionMapCopier.copyEnumToString(modelVariantActions);
            return this;
        }

        public final List<ModelVariantConfig.Builder> getDesiredModelVariants() {
            List<ModelVariantConfig.Builder> result = ModelVariantConfigListCopier.copyToBuilder(this.desiredModelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredModelVariants(Collection<ModelVariantConfig.BuilderImpl> desiredModelVariants) {
            this.desiredModelVariants = ModelVariantConfigListCopier.copyFromBuilder(desiredModelVariants);
        }

        @Override
        public final Builder desiredModelVariants(Collection<ModelVariantConfig> desiredModelVariants) {
            this.desiredModelVariants = ModelVariantConfigListCopier.copy(desiredModelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredModelVariants(ModelVariantConfig... desiredModelVariants) {
            desiredModelVariants(Arrays.asList(desiredModelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredModelVariants(Consumer<ModelVariantConfig.Builder>... desiredModelVariants) {
            desiredModelVariants(Stream.of(desiredModelVariants).map(c -> ModelVariantConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(InferenceExperimentStopDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopInferenceExperimentRequest build() {
            return new StopInferenceExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
