/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelCardVersionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListModelCardVersionsRequest.Builder, ListModelCardVersionsRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListModelCardVersionsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListModelCardVersionsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelCardVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(ListModelCardVersionsRequest::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(ListModelCardVersionsRequest::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelCardVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListModelCardVersionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListModelCardVersionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD,
            CREATION_TIME_BEFORE_FIELD, MAX_RESULTS_FIELD, MODEL_CARD_NAME_FIELD, MODEL_CARD_STATUS_FIELD, NEXT_TOKEN_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Integer maxResults;

    private final String modelCardName;

    private final String modelCardStatus;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListModelCardVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.maxResults = builder.maxResults;
        this.modelCardName = builder.modelCardName;
        this.modelCardStatus = builder.modelCardStatus;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Only list model card versions that were created after the time specified.
     * </p>
     * 
     * @return Only list model card versions that were created after the time specified.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Only list model card versions that were created before the time specified.
     * </p>
     * 
     * @return Only list model card versions that were created before the time specified.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * The maximum number of model card versions to list.
     * </p>
     * 
     * @return The maximum number of model card versions to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * List model card versions for the model card with the specified name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return List model card versions for the model card with the specified name or Amazon Resource Name (ARN).
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * Only list model card versions with the specified approval status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return Only list model card versions with the specified approval status.
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * Only list model card versions with the specified approval status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return Only list model card versions with the specified approval status.
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    /**
     * <p>
     * If the response to a previous <code>ListModelCardVersions</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of model card versions, use the token in the next request.
     * </p>
     * 
     * @return If the response to a previous <code>ListModelCardVersions</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of model card versions, use the token in the
     *         next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Sort listed model card versions by version. Sorts by version by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ModelCardVersionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort listed model card versions by version. Sorts by version by default.
     * @see ModelCardVersionSortBy
     */
    public final ModelCardVersionSortBy sortBy() {
        return ModelCardVersionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort listed model card versions by version. Sorts by version by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ModelCardVersionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort listed model card versions by version. Sorts by version by default.
     * @see ModelCardVersionSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Sort model card versions by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ModelCardSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort model card versions by ascending or descending order.
     * @see ModelCardSortOrder
     */
    public final ModelCardSortOrder sortOrder() {
        return ModelCardSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sort model card versions by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ModelCardSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort model card versions by ascending or descending order.
     * @see ModelCardSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardVersionsRequest)) {
            return false;
        }
        ListModelCardVersionsRequest other = (ListModelCardVersionsRequest) obj;
        return Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelCardVersionsRequest").add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore()).add("MaxResults", maxResults())
                .add("ModelCardName", modelCardName()).add("ModelCardStatus", modelCardStatusAsString())
                .add("NextToken", nextToken()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardVersionsRequest, T> g) {
        return obj -> g.apply((ListModelCardVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelCardVersionsRequest> {
        /**
         * <p>
         * Only list model card versions that were created after the time specified.
         * </p>
         * 
         * @param creationTimeAfter
         *        Only list model card versions that were created after the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Only list model card versions that were created before the time specified.
         * </p>
         * 
         * @param creationTimeBefore
         *        Only list model card versions that were created before the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * The maximum number of model card versions to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of model card versions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * List model card versions for the model card with the specified name or Amazon Resource Name (ARN).
         * </p>
         * 
         * @param modelCardName
         *        List model card versions for the model card with the specified name or Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * Only list model card versions with the specified approval status.
         * </p>
         * 
         * @param modelCardStatus
         *        Only list model card versions with the specified approval status.
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * Only list model card versions with the specified approval status.
         * </p>
         * 
         * @param modelCardStatus
         *        Only list model card versions with the specified approval status.
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        /**
         * <p>
         * If the response to a previous <code>ListModelCardVersions</code> request was truncated, the response includes
         * a <code>NextToken</code>. To retrieve the next set of model card versions, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to a previous <code>ListModelCardVersions</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of model card versions, use the token in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Sort listed model card versions by version. Sorts by version by default.
         * </p>
         * 
         * @param sortBy
         *        Sort listed model card versions by version. Sorts by version by default.
         * @see ModelCardVersionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardVersionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort listed model card versions by version. Sorts by version by default.
         * </p>
         * 
         * @param sortBy
         *        Sort listed model card versions by version. Sorts by version by default.
         * @see ModelCardVersionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardVersionSortBy
         */
        Builder sortBy(ModelCardVersionSortBy sortBy);

        /**
         * <p>
         * Sort model card versions by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort model card versions by ascending or descending order.
         * @see ModelCardSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sort model card versions by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort model card versions by ascending or descending order.
         * @see ModelCardSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardSortOrder
         */
        Builder sortOrder(ModelCardSortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Integer maxResults;

        private String modelCardName;

        private String modelCardStatus;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardVersionsRequest model) {
            super(model);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            maxResults(model.maxResults);
            modelCardName(model.modelCardName);
            modelCardStatus(model.modelCardStatus);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ModelCardVersionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(ModelCardSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelCardVersionsRequest build() {
            return new ListModelCardVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
