/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;

public class ListInferenceRecommendationsJobsPublisher
implements SdkPublisher<ListInferenceRecommendationsJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListInferenceRecommendationsJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceRecommendationsJobsPublisher(SageMakerAsyncClient client, ListInferenceRecommendationsJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceRecommendationsJobsPublisher(SageMakerAsyncClient client, ListInferenceRecommendationsJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceRecommendationsJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceRecommendationsJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InferenceRecommendationsJob> inferenceRecommendationsJobs() {
        Function<ListInferenceRecommendationsJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceRecommendationsJobs() != null) {
                return response.inferenceRecommendationsJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInferenceRecommendationsJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInferenceRecommendationsJobsResponseFetcher
    implements AsyncPageFetcher<ListInferenceRecommendationsJobsResponse> {
        private ListInferenceRecommendationsJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceRecommendationsJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceRecommendationsJobsResponse> nextPage(ListInferenceRecommendationsJobsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceRecommendationsJobsPublisher.this.client.listInferenceRecommendationsJobs(ListInferenceRecommendationsJobsPublisher.this.firstRequest);
            }
            return ListInferenceRecommendationsJobsPublisher.this.client.listInferenceRecommendationsJobs((ListInferenceRecommendationsJobsRequest)((Object)ListInferenceRecommendationsJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

