/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;

public class ListEdgeDeploymentPlansPublisher
implements SdkPublisher<ListEdgeDeploymentPlansResponse> {
    private final SageMakerAsyncClient client;
    private final ListEdgeDeploymentPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEdgeDeploymentPlansPublisher(SageMakerAsyncClient client, ListEdgeDeploymentPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEdgeDeploymentPlansPublisher(SageMakerAsyncClient client, ListEdgeDeploymentPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEdgeDeploymentPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEdgeDeploymentPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EdgeDeploymentPlanSummary> edgeDeploymentPlanSummaries() {
        Function<ListEdgeDeploymentPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgeDeploymentPlanSummaries() != null) {
                return response.edgeDeploymentPlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEdgeDeploymentPlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEdgeDeploymentPlansResponseFetcher
    implements AsyncPageFetcher<ListEdgeDeploymentPlansResponse> {
        private ListEdgeDeploymentPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgeDeploymentPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEdgeDeploymentPlansResponse> nextPage(ListEdgeDeploymentPlansResponse previousPage) {
            if (previousPage == null) {
                return ListEdgeDeploymentPlansPublisher.this.client.listEdgeDeploymentPlans(ListEdgeDeploymentPlansPublisher.this.firstRequest);
            }
            return ListEdgeDeploymentPlansPublisher.this.client.listEdgeDeploymentPlans((ListEdgeDeploymentPlansRequest)((Object)ListEdgeDeploymentPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

