/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordWrapper {
    NONE("None"),
    RECORD_IO("RecordIO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordWrapper> VALUE_MAP;
    private final String value;

    private RecordWrapper(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordWrapper fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordWrapper> knownValues() {
        EnumSet<RecordWrapper> knownValues = EnumSet.allOf(RecordWrapper.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordWrapper.class, RecordWrapper::toString);
    }
}

