/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelVariantAction {
    RETAIN("Retain"),
    REMOVE("Remove"),
    PROMOTE("Promote"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelVariantAction> VALUE_MAP;
    private final String value;

    private ModelVariantAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelVariantAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelVariantAction> knownValues() {
        EnumSet<ModelVariantAction> knownValues = EnumSet.allOf(ModelVariantAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelVariantAction.class, ModelVariantAction::toString);
    }
}

