/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelPackageType {
    VERSIONED("Versioned"),
    UNVERSIONED("Unversioned"),
    BOTH("Both"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelPackageType> VALUE_MAP;
    private final String value;

    private ModelPackageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelPackageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelPackageType> knownValues() {
        EnumSet<ModelPackageType> knownValues = EnumSet.allOf(ModelPackageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelPackageType.class, ModelPackageType::toString);
    }
}

