/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelMetadataFilterType {
    DOMAIN("Domain"),
    FRAMEWORK("Framework"),
    TASK("Task"),
    FRAMEWORK_VERSION("FrameworkVersion"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelMetadataFilterType> VALUE_MAP;
    private final String value;

    private ModelMetadataFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelMetadataFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelMetadataFilterType> knownValues() {
        EnumSet<ModelMetadataFilterType> knownValues = EnumSet.allOf(ModelMetadataFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelMetadataFilterType.class, ModelMetadataFilterType::toString);
    }
}

