/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.MonitoringEnvironmentMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelBiasAppSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelBiasAppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(ModelBiasAppSpecification.getter(ModelBiasAppSpecification::imageUri)).setter(ModelBiasAppSpecification.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<String> CONFIG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigUri").getter(ModelBiasAppSpecification.getter(ModelBiasAppSpecification::configUri)).setter(ModelBiasAppSpecification.setter(Builder::configUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigUri").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(ModelBiasAppSpecification.getter(ModelBiasAppSpecification::environment)).setter(ModelBiasAppSpecification.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, CONFIG_URI_FIELD, ENVIRONMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final String configUri;
    private final Map<String, String> environment;

    private ModelBiasAppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.configUri = builder.configUri;
        this.environment = builder.environment;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final String configUri() {
        return this.configUri;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.configUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelBiasAppSpecification)) {
            return false;
        }
        ModelBiasAppSpecification other = (ModelBiasAppSpecification)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.configUri(), other.configUri()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment());
    }

    public final String toString() {
        return ToString.builder((String)"ModelBiasAppSpecification").add("ImageUri", (Object)this.imageUri()).add("ConfigUri", (Object)this.configUri()).add("Environment", this.hasEnvironment() ? this.environment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ConfigUri": {
                return Optional.ofNullable(clazz.cast(this.configUri()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelBiasAppSpecification, T> g) {
        return obj -> g.apply((ModelBiasAppSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private String configUri;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelBiasAppSpecification model) {
            this.imageUri(model.imageUri);
            this.configUri(model.configUri);
            this.environment(model.environment);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final String getConfigUri() {
            return this.configUri;
        }

        public final void setConfigUri(String configUri) {
            this.configUri = configUri;
        }

        @Override
        public final Builder configUri(String configUri) {
            this.configUri = configUri;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
            return this;
        }

        public ModelBiasAppSpecification build() {
            return new ModelBiasAppSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelBiasAppSpecification> {
        public Builder imageUri(String var1);

        public Builder configUri(String var1);

        public Builder environment(Map<String, String> var1);
    }
}

