/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHumanTaskUisRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListHumanTaskUisRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListHumanTaskUisRequest.getter(ListHumanTaskUisRequest::creationTimeAfter)).setter(ListHumanTaskUisRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListHumanTaskUisRequest.getter(ListHumanTaskUisRequest::creationTimeBefore)).setter(ListHumanTaskUisRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListHumanTaskUisRequest.getter(ListHumanTaskUisRequest::sortOrderAsString)).setter(ListHumanTaskUisRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHumanTaskUisRequest.getter(ListHumanTaskUisRequest::nextToken)).setter(ListHumanTaskUisRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListHumanTaskUisRequest.getter(ListHumanTaskUisRequest::maxResults)).setter(ListHumanTaskUisRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final String sortOrder;
    private final String nextToken;
    private final Integer maxResults;

    private ListHumanTaskUisRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanTaskUisRequest)) {
            return false;
        }
        ListHumanTaskUisRequest other = (ListHumanTaskUisRequest)((Object)obj);
        return Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListHumanTaskUisRequest").add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanTaskUisRequest, T> g) {
        return obj -> g.apply((ListHumanTaskUisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private String sortOrder;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanTaskUisRequest model) {
            super(model);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHumanTaskUisRequest build() {
            return new ListHumanTaskUisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHumanTaskUisRequest> {
        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

