/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageVersionStatus {
    CREATING("CREATING"),
    CREATED("CREATED"),
    CREATE_FAILED("CREATE_FAILED"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageVersionStatus> VALUE_MAP;
    private final String value;

    private ImageVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageVersionStatus> knownValues() {
        EnumSet<ImageVersionStatus> knownValues = EnumSet.allOf(ImageVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageVersionStatus.class, ImageVersionStatus::toString);
    }
}

