/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageSortBy {
    CREATION_TIME("CREATION_TIME"),
    LAST_MODIFIED_TIME("LAST_MODIFIED_TIME"),
    IMAGE_NAME("IMAGE_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageSortBy> VALUE_MAP;
    private final String value;

    private ImageSortBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageSortBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageSortBy> knownValues() {
        EnumSet<ImageSortBy> knownValues = EnumSet.allOf(ImageSortBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageSortBy.class, ImageSortBy::toString);
    }
}

