/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowDefinitionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowDefinitionSummary> {
    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionName").getter(FlowDefinitionSummary.getter(FlowDefinitionSummary::flowDefinitionName)).setter(FlowDefinitionSummary.setter(Builder::flowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionArn").getter(FlowDefinitionSummary.getter(FlowDefinitionSummary::flowDefinitionArn)).setter(FlowDefinitionSummary.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionStatus").getter(FlowDefinitionSummary.getter(FlowDefinitionSummary::flowDefinitionStatusAsString)).setter(FlowDefinitionSummary.setter(Builder::flowDefinitionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FlowDefinitionSummary.getter(FlowDefinitionSummary::creationTime)).setter(FlowDefinitionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(FlowDefinitionSummary.getter(FlowDefinitionSummary::failureReason)).setter(FlowDefinitionSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_NAME_FIELD, FLOW_DEFINITION_ARN_FIELD, FLOW_DEFINITION_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String flowDefinitionName;
    private final String flowDefinitionArn;
    private final String flowDefinitionStatus;
    private final Instant creationTime;
    private final String failureReason;

    private FlowDefinitionSummary(BuilderImpl builder) {
        this.flowDefinitionName = builder.flowDefinitionName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.flowDefinitionStatus = builder.flowDefinitionStatus;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
    }

    public final String flowDefinitionName() {
        return this.flowDefinitionName;
    }

    public final String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public final FlowDefinitionStatus flowDefinitionStatus() {
        return FlowDefinitionStatus.fromValue(this.flowDefinitionStatus);
    }

    public final String flowDefinitionStatusAsString() {
        return this.flowDefinitionStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinitionSummary)) {
            return false;
        }
        FlowDefinitionSummary other = (FlowDefinitionSummary)obj;
        return Objects.equals(this.flowDefinitionName(), other.flowDefinitionName()) && Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.flowDefinitionStatusAsString(), other.flowDefinitionStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"FlowDefinitionSummary").add("FlowDefinitionName", (Object)this.flowDefinitionName()).add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("FlowDefinitionStatus", (Object)this.flowDefinitionStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionName()));
            }
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "FlowDefinitionStatus": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinitionSummary, T> g) {
        return obj -> g.apply((FlowDefinitionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowDefinitionName;
        private String flowDefinitionArn;
        private String flowDefinitionStatus;
        private Instant creationTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinitionSummary model) {
            this.flowDefinitionName(model.flowDefinitionName);
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.flowDefinitionStatus(model.flowDefinitionStatus);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
        }

        public final String getFlowDefinitionName() {
            return this.flowDefinitionName;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        @Override
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final String getFlowDefinitionStatus() {
            return this.flowDefinitionStatus;
        }

        public final void setFlowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
        }

        @Override
        public final Builder flowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
            return this;
        }

        @Override
        public final Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus) {
            this.flowDefinitionStatus(flowDefinitionStatus == null ? null : flowDefinitionStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public FlowDefinitionSummary build() {
            return new FlowDefinitionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowDefinitionSummary> {
        public Builder flowDefinitionName(String var1);

        public Builder flowDefinitionArn(String var1);

        public Builder flowDefinitionStatus(String var1);

        public Builder flowDefinitionStatus(FlowDefinitionStatus var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

