/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeviceNamesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterDevicesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DeregisterDevicesRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DeregisterDevicesRequest.getter(DeregisterDevicesRequest::deviceFleetName)).setter(DeregisterDevicesRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<List<String>> DEVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceNames").getter(DeregisterDevicesRequest.getter(DeregisterDevicesRequest::deviceNames)).setter(DeregisterDevicesRequest.setter(Builder::deviceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD, DEVICE_NAMES_FIELD));
    private final String deviceFleetName;
    private final List<String> deviceNames;

    private DeregisterDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.deviceNames = builder.deviceNames;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final boolean hasDeviceNames() {
        return this.deviceNames != null && !(this.deviceNames instanceof SdkAutoConstructList);
    }

    public final List<String> deviceNames() {
        return this.deviceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceNames() ? this.deviceNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterDevicesRequest)) {
            return false;
        }
        DeregisterDevicesRequest other = (DeregisterDevicesRequest)((Object)obj);
        return Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && this.hasDeviceNames() == other.hasDeviceNames() && Objects.equals(this.deviceNames(), other.deviceNames());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterDevicesRequest").add("DeviceFleetName", (Object)this.deviceFleetName()).add("DeviceNames", this.hasDeviceNames() ? this.deviceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "DeviceNames": {
                return Optional.ofNullable(clazz.cast(this.deviceNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterDevicesRequest, T> g) {
        return obj -> g.apply((DeregisterDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String deviceFleetName;
        private List<String> deviceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterDevicesRequest model) {
            super(model);
            this.deviceFleetName(model.deviceFleetName);
            this.deviceNames(model.deviceNames);
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final Collection<String> getDeviceNames() {
            if (this.deviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceNames;
        }

        public final void setDeviceNames(Collection<String> deviceNames) {
            this.deviceNames = DeviceNamesCopier.copy(deviceNames);
        }

        @Override
        public final Builder deviceNames(Collection<String> deviceNames) {
            this.deviceNames = DeviceNamesCopier.copy(deviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceNames(String ... deviceNames) {
            this.deviceNames(Arrays.asList(deviceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterDevicesRequest build() {
            return new DeregisterDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterDevicesRequest> {
        public Builder deviceFleetName(String var1);

        public Builder deviceNames(Collection<String> var1);

        public Builder deviceNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

