/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomImage> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(CustomImage.getter(CustomImage::imageName)).setter(CustomImage.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<Integer> IMAGE_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImageVersionNumber").getter(CustomImage.getter(CustomImage::imageVersionNumber)).setter(CustomImage.setter(Builder::imageVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionNumber").build()}).build();
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppImageConfigName").getter(CustomImage.getter(CustomImage::appImageConfigName)).setter(CustomImage.setter(Builder::appImageConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD, IMAGE_VERSION_NUMBER_FIELD, APP_IMAGE_CONFIG_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageName;
    private final Integer imageVersionNumber;
    private final String appImageConfigName;

    private CustomImage(BuilderImpl builder) {
        this.imageName = builder.imageName;
        this.imageVersionNumber = builder.imageVersionNumber;
        this.appImageConfigName = builder.appImageConfigName;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final Integer imageVersionNumber() {
        return this.imageVersionNumber;
    }

    public final String appImageConfigName() {
        return this.appImageConfigName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.appImageConfigName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomImage)) {
            return false;
        }
        CustomImage other = (CustomImage)obj;
        return Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageVersionNumber(), other.imageVersionNumber()) && Objects.equals(this.appImageConfigName(), other.appImageConfigName());
    }

    public final String toString() {
        return ToString.builder((String)"CustomImage").add("ImageName", (Object)this.imageName()).add("ImageVersionNumber", (Object)this.imageVersionNumber()).add("AppImageConfigName", (Object)this.appImageConfigName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.imageVersionNumber()));
            }
            case "AppImageConfigName": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomImage, T> g) {
        return obj -> g.apply((CustomImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageName;
        private Integer imageVersionNumber;
        private String appImageConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomImage model) {
            this.imageName(model.imageName);
            this.imageVersionNumber(model.imageVersionNumber);
            this.appImageConfigName(model.appImageConfigName);
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final Integer getImageVersionNumber() {
            return this.imageVersionNumber;
        }

        public final void setImageVersionNumber(Integer imageVersionNumber) {
            this.imageVersionNumber = imageVersionNumber;
        }

        @Override
        public final Builder imageVersionNumber(Integer imageVersionNumber) {
            this.imageVersionNumber = imageVersionNumber;
            return this;
        }

        public final String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public CustomImage build() {
            return new CustomImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomImage> {
        public Builder imageName(String var1);

        public Builder imageVersionNumber(Integer var1);

        public Builder appImageConfigName(String var1);
    }
}

