/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceCatalog;

public class ListResourceCatalogsPublisher
implements SdkPublisher<ListResourceCatalogsResponse> {
    private final SageMakerAsyncClient client;
    private final ListResourceCatalogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceCatalogsPublisher(SageMakerAsyncClient client, ListResourceCatalogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceCatalogsPublisher(SageMakerAsyncClient client, ListResourceCatalogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceCatalogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceCatalogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceCatalog> resourceCatalogs() {
        Function<ListResourceCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCatalogs() != null) {
                return response.resourceCatalogs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceCatalogsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceCatalogsResponseFetcher
    implements AsyncPageFetcher<ListResourceCatalogsResponse> {
        private ListResourceCatalogsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceCatalogsResponse> nextPage(ListResourceCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceCatalogsPublisher.this.client.listResourceCatalogs(ListResourceCatalogsPublisher.this.firstRequest);
            }
            return ListResourceCatalogsPublisher.this.client.listResourceCatalogs((ListResourceCatalogsRequest)((Object)ListResourceCatalogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

