/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetPlatformAccelerator {
    INTEL_GRAPHICS("INTEL_GRAPHICS"),
    MALI("MALI"),
    NVIDIA("NVIDIA"),
    NNA("NNA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetPlatformAccelerator> VALUE_MAP;
    private final String value;

    private TargetPlatformAccelerator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetPlatformAccelerator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetPlatformAccelerator> knownValues() {
        EnumSet<TargetPlatformAccelerator> knownValues = EnumSet.allOf(TargetPlatformAccelerator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetPlatformAccelerator.class, TargetPlatformAccelerator::toString);
    }
}

