/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessingS3InputMode {
    PIPE("Pipe"),
    FILE("File"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessingS3InputMode> VALUE_MAP;
    private final String value;

    private ProcessingS3InputMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessingS3InputMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessingS3InputMode> knownValues() {
        EnumSet<ProcessingS3InputMode> knownValues = EnumSet.allOf(ProcessingS3InputMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessingS3InputMode.class, ProcessingS3InputMode::toString);
    }
}

