/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelInfrastructureType {
    REAL_TIME_INFERENCE("RealTimeInference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelInfrastructureType> VALUE_MAP;
    private final String value;

    private ModelInfrastructureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelInfrastructureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelInfrastructureType> knownValues() {
        EnumSet<ModelInfrastructureType> knownValues = EnumSet.allOf(ModelInfrastructureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelInfrastructureType.class, ModelInfrastructureType::toString);
    }
}

