/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BooleanOperator {
    AND("And"),
    OR("Or"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BooleanOperator> VALUE_MAP;
    private final String value;

    private BooleanOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BooleanOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BooleanOperator> knownValues() {
        EnumSet<BooleanOperator> knownValues = EnumSet.allOf(BooleanOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BooleanOperator.class, BooleanOperator::toString);
    }
}

