/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of components that defines the time-series.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesConfig.Builder, TimeSeriesConfig> {
    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAttributeName").getter(getter(TimeSeriesConfig::targetAttributeName))
            .setter(setter(Builder::targetAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build())
            .build();

    private static final SdkField<String> TIMESTAMP_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampAttributeName").getter(getter(TimeSeriesConfig::timestampAttributeName))
            .setter(setter(Builder::timestampAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampAttributeName").build())
            .build();

    private static final SdkField<String> ITEM_IDENTIFIER_ATTRIBUTE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ItemIdentifierAttributeName")
            .getter(getter(TimeSeriesConfig::itemIdentifierAttributeName))
            .setter(setter(Builder::itemIdentifierAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemIdentifierAttributeName")
                    .build()).build();

    private static final SdkField<List<String>> GROUPING_ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupingAttributeNames")
            .getter(getter(TimeSeriesConfig::groupingAttributeNames))
            .setter(setter(Builder::groupingAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingAttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ATTRIBUTE_NAME_FIELD,
            TIMESTAMP_ATTRIBUTE_NAME_FIELD, ITEM_IDENTIFIER_ATTRIBUTE_NAME_FIELD, GROUPING_ATTRIBUTE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetAttributeName;

    private final String timestampAttributeName;

    private final String itemIdentifierAttributeName;

    private final List<String> groupingAttributeNames;

    private TimeSeriesConfig(BuilderImpl builder) {
        this.targetAttributeName = builder.targetAttributeName;
        this.timestampAttributeName = builder.timestampAttributeName;
        this.itemIdentifierAttributeName = builder.itemIdentifierAttributeName;
        this.groupingAttributeNames = builder.groupingAttributeNames;
    }

    /**
     * <p>
     * The name of the column representing the target variable that you want to predict for each item in your dataset.
     * The data type of the target variable must be numerical.
     * </p>
     * 
     * @return The name of the column representing the target variable that you want to predict for each item in your
     *         dataset. The data type of the target variable must be numerical.
     */
    public final String targetAttributeName() {
        return targetAttributeName;
    }

    /**
     * <p>
     * The name of the column indicating a point in time at which the target value of a given item is recorded.
     * </p>
     * 
     * @return The name of the column indicating a point in time at which the target value of a given item is recorded.
     */
    public final String timestampAttributeName() {
        return timestampAttributeName;
    }

    /**
     * <p>
     * The name of the column that represents the set of item identifiers for which you want to predict the target
     * value.
     * </p>
     * 
     * @return The name of the column that represents the set of item identifiers for which you want to predict the
     *         target value.
     */
    public final String itemIdentifierAttributeName() {
        return itemIdentifierAttributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupingAttributeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGroupingAttributeNames() {
        return groupingAttributeNames != null && !(groupingAttributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of columns names that can be grouped with the item identifier column to create a composite key for which a
     * target value is predicted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupingAttributeNames} method.
     * </p>
     * 
     * @return A set of columns names that can be grouped with the item identifier column to create a composite key for
     *         which a target value is predicted.
     */
    public final List<String> groupingAttributeNames() {
        return groupingAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestampAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(itemIdentifierAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupingAttributeNames() ? groupingAttributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesConfig)) {
            return false;
        }
        TimeSeriesConfig other = (TimeSeriesConfig) obj;
        return Objects.equals(targetAttributeName(), other.targetAttributeName())
                && Objects.equals(timestampAttributeName(), other.timestampAttributeName())
                && Objects.equals(itemIdentifierAttributeName(), other.itemIdentifierAttributeName())
                && hasGroupingAttributeNames() == other.hasGroupingAttributeNames()
                && Objects.equals(groupingAttributeNames(), other.groupingAttributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesConfig").add("TargetAttributeName", targetAttributeName())
                .add("TimestampAttributeName", timestampAttributeName())
                .add("ItemIdentifierAttributeName", itemIdentifierAttributeName())
                .add("GroupingAttributeNames", hasGroupingAttributeNames() ? groupingAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetAttributeName":
            return Optional.ofNullable(clazz.cast(targetAttributeName()));
        case "TimestampAttributeName":
            return Optional.ofNullable(clazz.cast(timestampAttributeName()));
        case "ItemIdentifierAttributeName":
            return Optional.ofNullable(clazz.cast(itemIdentifierAttributeName()));
        case "GroupingAttributeNames":
            return Optional.ofNullable(clazz.cast(groupingAttributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesConfig, T> g) {
        return obj -> g.apply((TimeSeriesConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesConfig> {
        /**
         * <p>
         * The name of the column representing the target variable that you want to predict for each item in your
         * dataset. The data type of the target variable must be numerical.
         * </p>
         * 
         * @param targetAttributeName
         *        The name of the column representing the target variable that you want to predict for each item in your
         *        dataset. The data type of the target variable must be numerical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAttributeName(String targetAttributeName);

        /**
         * <p>
         * The name of the column indicating a point in time at which the target value of a given item is recorded.
         * </p>
         * 
         * @param timestampAttributeName
         *        The name of the column indicating a point in time at which the target value of a given item is
         *        recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampAttributeName(String timestampAttributeName);

        /**
         * <p>
         * The name of the column that represents the set of item identifiers for which you want to predict the target
         * value.
         * </p>
         * 
         * @param itemIdentifierAttributeName
         *        The name of the column that represents the set of item identifiers for which you want to predict the
         *        target value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemIdentifierAttributeName(String itemIdentifierAttributeName);

        /**
         * <p>
         * A set of columns names that can be grouped with the item identifier column to create a composite key for
         * which a target value is predicted.
         * </p>
         * 
         * @param groupingAttributeNames
         *        A set of columns names that can be grouped with the item identifier column to create a composite key
         *        for which a target value is predicted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeNames(Collection<String> groupingAttributeNames);

        /**
         * <p>
         * A set of columns names that can be grouped with the item identifier column to create a composite key for
         * which a target value is predicted.
         * </p>
         * 
         * @param groupingAttributeNames
         *        A set of columns names that can be grouped with the item identifier column to create a composite key
         *        for which a target value is predicted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeNames(String... groupingAttributeNames);
    }

    static final class BuilderImpl implements Builder {
        private String targetAttributeName;

        private String timestampAttributeName;

        private String itemIdentifierAttributeName;

        private List<String> groupingAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesConfig model) {
            targetAttributeName(model.targetAttributeName);
            timestampAttributeName(model.timestampAttributeName);
            itemIdentifierAttributeName(model.itemIdentifierAttributeName);
            groupingAttributeNames(model.groupingAttributeNames);
        }

        public final String getTargetAttributeName() {
            return targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final String getTimestampAttributeName() {
            return timestampAttributeName;
        }

        public final void setTimestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
        }

        @Override
        public final Builder timestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
            return this;
        }

        public final String getItemIdentifierAttributeName() {
            return itemIdentifierAttributeName;
        }

        public final void setItemIdentifierAttributeName(String itemIdentifierAttributeName) {
            this.itemIdentifierAttributeName = itemIdentifierAttributeName;
        }

        @Override
        public final Builder itemIdentifierAttributeName(String itemIdentifierAttributeName) {
            this.itemIdentifierAttributeName = itemIdentifierAttributeName;
            return this;
        }

        public final Collection<String> getGroupingAttributeNames() {
            if (groupingAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return groupingAttributeNames;
        }

        public final void setGroupingAttributeNames(Collection<String> groupingAttributeNames) {
            this.groupingAttributeNames = GroupingAttributeNamesCopier.copy(groupingAttributeNames);
        }

        @Override
        public final Builder groupingAttributeNames(Collection<String> groupingAttributeNames) {
            this.groupingAttributeNames = GroupingAttributeNamesCopier.copy(groupingAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeNames(String... groupingAttributeNames) {
            groupingAttributeNames(Arrays.asList(groupingAttributeNames));
            return this;
        }

        @Override
        public TimeSeriesConfig build() {
            return new TimeSeriesConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
