/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineExecutionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListPipelineExecutionsRequest.Builder, ListPipelineExecutionsRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(ListPipelineExecutionsRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(ListPipelineExecutionsRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(ListPipelineExecutionsRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListPipelineExecutionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListPipelineExecutionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelineExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPipelineExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String pipelineName;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListPipelineExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * A filter that returns the pipeline executions that were created after a specified time.
     * </p>
     * 
     * @return A filter that returns the pipeline executions that were created after a specified time.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * A filter that returns the pipeline executions that were created before a specified time.
     * </p>
     * 
     * @return A filter that returns the pipeline executions that were created before a specified time.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The field by which to sort results. The default is <code>CreatedTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortPipelineExecutionsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default is <code>CreatedTime</code>.
     * @see SortPipelineExecutionsBy
     */
    public final SortPipelineExecutionsBy sortBy() {
        return SortPipelineExecutionsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field by which to sort results. The default is <code>CreatedTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortPipelineExecutionsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default is <code>CreatedTime</code>.
     * @see SortPipelineExecutionsBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the
     *         next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of pipeline executions to return in the response.
     * </p>
     * 
     * @return The maximum number of pipeline executions to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionsRequest)) {
            return false;
        }
        ListPipelineExecutionsRequest other = (ListPipelineExecutionsRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineExecutionsRequest").add("PipelineName", pipelineName())
                .add("CreatedAfter", createdAfter()).add("CreatedBefore", createdBefore()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineExecutionsRequest, T> g) {
        return obj -> g.apply((ListPipelineExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelineExecutionsRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name or Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * A filter that returns the pipeline executions that were created after a specified time.
         * </p>
         * 
         * @param createdAfter
         *        A filter that returns the pipeline executions that were created after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * A filter that returns the pipeline executions that were created before a specified time.
         * </p>
         * 
         * @param createdBefore
         *        A filter that returns the pipeline executions that were created before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The field by which to sort results. The default is <code>CreatedTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default is <code>CreatedTime</code>.
         * @see SortPipelineExecutionsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortPipelineExecutionsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field by which to sort results. The default is <code>CreatedTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default is <code>CreatedTime</code>.
         * @see SortPipelineExecutionsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortPipelineExecutionsBy
         */
        Builder sortBy(SortPipelineExecutionsBy sortBy);

        /**
         * <p>
         * The sort order for results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response
         * includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of pipeline executions to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of pipeline executions to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private Instant createdAfter;

        private Instant createdBefore;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionsRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortPipelineExecutionsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPipelineExecutionsRequest build() {
            return new ListPipelineExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
