/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceExperimentsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListInferenceExperimentsRequest.Builder, ListInferenceExperimentsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListInferenceExperimentsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListInferenceExperimentsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListInferenceExperimentsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListInferenceExperimentsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListInferenceExperimentsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListInferenceExperimentsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListInferenceExperimentsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListInferenceExperimentsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListInferenceExperimentsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceExperimentsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceExperimentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD,
            TYPE_FIELD, STATUS_EQUALS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD,
            LAST_MODIFIED_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String nameContains;

    private final String type;

    private final String statusEquals;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListInferenceExperimentsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.type = builder.type;
        this.statusEquals = builder.statusEquals;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Selects inference experiments whose names contain this name.
     * </p>
     * 
     * @return Selects inference experiments whose names contain this name.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Selects inference experiments of this type. For the possible types of inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     * >CreateInferenceExperiment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Selects inference experiments of this type. For the possible types of inference experiments, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     *         >CreateInferenceExperiment</a>.
     * @see InferenceExperimentType
     */
    public final InferenceExperimentType type() {
        return InferenceExperimentType.fromValue(type);
    }

    /**
     * <p>
     * Selects inference experiments of this type. For the possible types of inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     * >CreateInferenceExperiment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Selects inference experiments of this type. For the possible types of inference experiments, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     *         >CreateInferenceExperiment</a>.
     * @see InferenceExperimentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Selects inference experiments which are in this status. For the possible statuses, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
     * >DescribeInferenceExperiment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Selects inference experiments which are in this status. For the possible statuses, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
     *         >DescribeInferenceExperiment</a>.
     * @see InferenceExperimentStatus
     */
    public final InferenceExperimentStatus statusEquals() {
        return InferenceExperimentStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Selects inference experiments which are in this status. For the possible statuses, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
     * >DescribeInferenceExperiment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Selects inference experiments which are in this status. For the possible statuses, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
     *         >DescribeInferenceExperiment</a>.
     * @see InferenceExperimentStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * Selects inference experiments which were created after this timestamp.
     * </p>
     * 
     * @return Selects inference experiments which were created after this timestamp.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Selects inference experiments which were created before this timestamp.
     * </p>
     * 
     * @return Selects inference experiments which were created before this timestamp.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Selects inference experiments which were last modified after this timestamp.
     * </p>
     * 
     * @return Selects inference experiments which were last modified after this timestamp.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Selects inference experiments which were last modified before this timestamp.
     * </p>
     * 
     * @return Selects inference experiments which were last modified before this timestamp.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * The column by which to sort the listed inference experiments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortInferenceExperimentsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The column by which to sort the listed inference experiments.
     * @see SortInferenceExperimentsBy
     */
    public final SortInferenceExperimentsBy sortBy() {
        return SortInferenceExperimentsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The column by which to sort the listed inference experiments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortInferenceExperimentsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The column by which to sort the listed inference experiments.
     * @see SortInferenceExperimentsBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The direction of sorting (ascending or descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The direction of sorting (ascending or descending).
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The direction of sorting (ascending or descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The direction of sorting (ascending or descending).
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The response from the last list when returning a list large enough to need tokening.
     * </p>
     * 
     * @return The response from the last list when returning a list large enough to need tokening.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to select.
     * </p>
     * 
     * @return The maximum number of results to select.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExperimentsRequest)) {
            return false;
        }
        ListInferenceExperimentsRequest other = (ListInferenceExperimentsRequest) obj;
        return Objects.equals(nameContains(), other.nameContains()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceExperimentsRequest").add("NameContains", nameContains())
                .add("Type", typeAsString()).add("StatusEquals", statusEqualsAsString())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExperimentsRequest, T> g) {
        return obj -> g.apply((ListInferenceExperimentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInferenceExperimentsRequest> {
        /**
         * <p>
         * Selects inference experiments whose names contain this name.
         * </p>
         * 
         * @param nameContains
         *        Selects inference experiments whose names contain this name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Selects inference experiments of this type. For the possible types of inference experiments, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
         * >CreateInferenceExperiment</a>.
         * </p>
         * 
         * @param type
         *        Selects inference experiments of this type. For the possible types of inference experiments, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html">
         *        CreateInferenceExperiment</a>.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(String type);

        /**
         * <p>
         * Selects inference experiments of this type. For the possible types of inference experiments, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
         * >CreateInferenceExperiment</a>.
         * </p>
         * 
         * @param type
         *        Selects inference experiments of this type. For the possible types of inference experiments, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html">
         *        CreateInferenceExperiment</a>.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(InferenceExperimentType type);

        /**
         * <p>
         * Selects inference experiments which are in this status. For the possible statuses, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
         * >DescribeInferenceExperiment</a>.
         * </p>
         * 
         * @param statusEquals
         *        Selects inference experiments which are in this status. For the possible statuses, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
         *        >DescribeInferenceExperiment</a>.
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Selects inference experiments which are in this status. For the possible statuses, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
         * >DescribeInferenceExperiment</a>.
         * </p>
         * 
         * @param statusEquals
         *        Selects inference experiments which are in this status. For the possible statuses, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html"
         *        >DescribeInferenceExperiment</a>.
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder statusEquals(InferenceExperimentStatus statusEquals);

        /**
         * <p>
         * Selects inference experiments which were created after this timestamp.
         * </p>
         * 
         * @param creationTimeAfter
         *        Selects inference experiments which were created after this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Selects inference experiments which were created before this timestamp.
         * </p>
         * 
         * @param creationTimeBefore
         *        Selects inference experiments which were created before this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Selects inference experiments which were last modified after this timestamp.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Selects inference experiments which were last modified after this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Selects inference experiments which were last modified before this timestamp.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Selects inference experiments which were last modified before this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * The column by which to sort the listed inference experiments.
         * </p>
         * 
         * @param sortBy
         *        The column by which to sort the listed inference experiments.
         * @see SortInferenceExperimentsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortInferenceExperimentsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The column by which to sort the listed inference experiments.
         * </p>
         * 
         * @param sortBy
         *        The column by which to sort the listed inference experiments.
         * @see SortInferenceExperimentsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortInferenceExperimentsBy
         */
        Builder sortBy(SortInferenceExperimentsBy sortBy);

        /**
         * <p>
         * The direction of sorting (ascending or descending).
         * </p>
         * 
         * @param sortOrder
         *        The direction of sorting (ascending or descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The direction of sorting (ascending or descending).
         * </p>
         * 
         * @param sortOrder
         *        The direction of sorting (ascending or descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The response from the last list when returning a list large enough to need tokening.
         * </p>
         * 
         * @param nextToken
         *        The response from the last list when returning a list large enough to need tokening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to select.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nameContains;

        private String type;

        private String statusEquals;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant lastModifiedTimeAfter;

        private Instant lastModifiedTimeBefore;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExperimentsRequest model) {
            super(model);
            nameContains(model.nameContains);
            type(model.type);
            statusEquals(model.statusEquals);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(InferenceExperimentStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortInferenceExperimentsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceExperimentsRequest build() {
            return new ListInferenceExperimentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
