/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCandidatesForAutoMlJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListCandidatesForAutoMlJobRequest.Builder, ListCandidatesForAutoMlJobRequest> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(ListCandidatesForAutoMlJobRequest::autoMLJobName))
            .setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListCandidatesForAutoMlJobRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> CANDIDATE_NAME_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateNameEquals").getter(getter(ListCandidatesForAutoMlJobRequest::candidateNameEquals))
            .setter(setter(Builder::candidateNameEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateNameEquals").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListCandidatesForAutoMlJobRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListCandidatesForAutoMlJobRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCandidatesForAutoMlJobRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCandidatesForAutoMlJobRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            STATUS_EQUALS_FIELD, CANDIDATE_NAME_EQUALS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final String autoMLJobName;

    private final String statusEquals;

    private final String candidateNameEquals;

    private final String sortOrder;

    private final String sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListCandidatesForAutoMlJobRequest(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.statusEquals = builder.statusEquals;
        this.candidateNameEquals = builder.candidateNameEquals;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List the candidates created for the job by providing the job's name.
     * </p>
     * 
     * @return List the candidates created for the job by providing the job's name.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * <p>
     * List the candidates for the job and filter by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return List the candidates for the job and filter by status.
     * @see CandidateStatus
     */
    public final CandidateStatus statusEquals() {
        return CandidateStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * List the candidates for the job and filter by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return List the candidates for the job and filter by status.
     * @see CandidateStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * List the candidates for the job and filter by candidate name.
     * </p>
     * 
     * @return List the candidates for the job and filter by candidate name.
     */
    public final String candidateNameEquals() {
        return candidateNameEquals;
    }

    /**
     * <p>
     * The sort order for the results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link AutoMLSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is <code>Ascending</code>.
     * @see AutoMLSortOrder
     */
    public final AutoMLSortOrder sortOrder() {
        return AutoMLSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for the results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link AutoMLSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is <code>Ascending</code>.
     * @see AutoMLSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CandidateSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is <code>Descending</code>.
     * @see CandidateSortBy
     */
    public final CandidateSortBy sortBy() {
        return CandidateSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CandidateSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is <code>Descending</code>.
     * @see CandidateSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * List the job's candidates up to a specified limit.
     * </p>
     * 
     * @return List the job's candidates up to a specified limit.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(candidateNameEquals());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCandidatesForAutoMlJobRequest)) {
            return false;
        }
        ListCandidatesForAutoMlJobRequest other = (ListCandidatesForAutoMlJobRequest) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(candidateNameEquals(), other.candidateNameEquals())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCandidatesForAutoMlJobRequest").add("AutoMLJobName", autoMLJobName())
                .add("StatusEquals", statusEqualsAsString()).add("CandidateNameEquals", candidateNameEquals())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "CandidateNameEquals":
            return Optional.ofNullable(clazz.cast(candidateNameEquals()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCandidatesForAutoMlJobRequest, T> g) {
        return obj -> g.apply((ListCandidatesForAutoMlJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCandidatesForAutoMlJobRequest> {
        /**
         * <p>
         * List the candidates created for the job by providing the job's name.
         * </p>
         * 
         * @param autoMLJobName
         *        List the candidates created for the job by providing the job's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * List the candidates for the job and filter by status.
         * </p>
         * 
         * @param statusEquals
         *        List the candidates for the job and filter by status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * List the candidates for the job and filter by status.
         * </p>
         * 
         * @param statusEquals
         *        List the candidates for the job and filter by status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder statusEquals(CandidateStatus statusEquals);

        /**
         * <p>
         * List the candidates for the job and filter by candidate name.
         * </p>
         * 
         * @param candidateNameEquals
         *        List the candidates for the job and filter by candidate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateNameEquals(String candidateNameEquals);

        /**
         * <p>
         * The sort order for the results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is <code>Ascending</code>.
         * @see AutoMLSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for the results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is <code>Ascending</code>.
         * @see AutoMLSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLSortOrder
         */
        Builder sortOrder(AutoMLSortOrder sortOrder);

        /**
         * <p>
         * The parameter by which to sort the results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is <code>Descending</code>.
         * @see CandidateSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The parameter by which to sort the results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is <code>Descending</code>.
         * @see CandidateSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateSortBy
         */
        Builder sortBy(CandidateSortBy sortBy);

        /**
         * <p>
         * List the job's candidates up to a specified limit.
         * </p>
         * 
         * @param maxResults
         *        List the job's candidates up to a specified limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String autoMLJobName;

        private String statusEquals;

        private String candidateNameEquals;

        private String sortOrder;

        private String sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCandidatesForAutoMlJobRequest model) {
            super(model);
            autoMLJobName(model.autoMLJobName);
            statusEquals(model.statusEquals);
            candidateNameEquals(model.candidateNameEquals);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(CandidateStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getCandidateNameEquals() {
            return candidateNameEquals;
        }

        public final void setCandidateNameEquals(String candidateNameEquals) {
            this.candidateNameEquals = candidateNameEquals;
        }

        @Override
        public final Builder candidateNameEquals(String candidateNameEquals) {
            this.candidateNameEquals = candidateNameEquals;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(AutoMLSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CandidateSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCandidatesForAutoMlJobRequest build() {
            return new ListCandidatesForAutoMlJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
