/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total resources consumed by your hyperparameter tuning job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobConsumedResources implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobConsumedResources.Builder, HyperParameterTuningJobConsumedResources> {
    private static final SdkField<Integer> RUNTIME_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuntimeInSeconds").getter(getter(HyperParameterTuningJobConsumedResources::runtimeInSeconds))
            .setter(setter(Builder::runtimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer runtimeInSeconds;

    private HyperParameterTuningJobConsumedResources(BuilderImpl builder) {
        this.runtimeInSeconds = builder.runtimeInSeconds;
    }

    /**
     * <p>
     * The wall clock runtime in seconds used by your hyperparameter tuning job.
     * </p>
     * 
     * @return The wall clock runtime in seconds used by your hyperparameter tuning job.
     */
    public final Integer runtimeInSeconds() {
        return runtimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runtimeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobConsumedResources)) {
            return false;
        }
        HyperParameterTuningJobConsumedResources other = (HyperParameterTuningJobConsumedResources) obj;
        return Objects.equals(runtimeInSeconds(), other.runtimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobConsumedResources").add("RuntimeInSeconds", runtimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuntimeInSeconds":
            return Optional.ofNullable(clazz.cast(runtimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobConsumedResources, T> g) {
        return obj -> g.apply((HyperParameterTuningJobConsumedResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobConsumedResources> {
        /**
         * <p>
         * The wall clock runtime in seconds used by your hyperparameter tuning job.
         * </p>
         * 
         * @param runtimeInSeconds
         *        The wall clock runtime in seconds used by your hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeInSeconds(Integer runtimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer runtimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobConsumedResources model) {
            runtimeInSeconds(model.runtimeInSeconds);
        }

        public final Integer getRuntimeInSeconds() {
            return runtimeInSeconds;
        }

        public final void setRuntimeInSeconds(Integer runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds;
        }

        @Override
        public final Builder runtimeInSeconds(Integer runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds;
            return this;
        }

        @Override
        public HyperParameterTuningJobConsumedResources build() {
            return new HyperParameterTuningJobConsumedResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
