/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelCardExportJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelCardExportJobResponse.Builder, DescribeModelCardExportJobResponse> {
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobName").getter(getter(DescribeModelCardExportJobResponse::modelCardExportJobName))
            .setter(setter(Builder::modelCardExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build())
            .build();

    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobArn").getter(getter(DescribeModelCardExportJobResponse::modelCardExportJobArn))
            .setter(setter(Builder::modelCardExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeModelCardExportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(DescribeModelCardExportJobResponse::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(DescribeModelCardExportJobResponse::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<ModelCardExportOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ModelCardExportOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(DescribeModelCardExportJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ModelCardExportOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeModelCardExportJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAt").getter(getter(DescribeModelCardExportJobResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeModelCardExportJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<ModelCardExportArtifacts> EXPORT_ARTIFACTS_FIELD = SdkField
            .<ModelCardExportArtifacts> builder(MarshallingType.SDK_POJO).memberName("ExportArtifacts")
            .getter(getter(DescribeModelCardExportJobResponse::exportArtifacts)).setter(setter(Builder::exportArtifacts))
            .constructor(ModelCardExportArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArtifacts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_CARD_EXPORT_JOB_NAME_FIELD, MODEL_CARD_EXPORT_JOB_ARN_FIELD, STATUS_FIELD, MODEL_CARD_NAME_FIELD,
            MODEL_CARD_VERSION_FIELD, OUTPUT_CONFIG_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, FAILURE_REASON_FIELD,
            EXPORT_ARTIFACTS_FIELD));

    private final String modelCardExportJobName;

    private final String modelCardExportJobArn;

    private final String status;

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final ModelCardExportOutputConfig outputConfig;

    private final Instant createdAt;

    private final Instant lastModifiedAt;

    private final String failureReason;

    private final ModelCardExportArtifacts exportArtifacts;

    private DescribeModelCardExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.modelCardExportJobArn = builder.modelCardExportJobArn;
        this.status = builder.status;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.outputConfig = builder.outputConfig;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.failureReason = builder.failureReason;
        this.exportArtifacts = builder.exportArtifacts;
    }

    /**
     * <p>
     * The name of the model card export job to describe.
     * </p>
     * 
     * @return The name of the model card export job to describe.
     */
    public final String modelCardExportJobName() {
        return modelCardExportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model card export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model card export job.
     */
    public final String modelCardExportJobArn() {
        return modelCardExportJobArn;
    }

    /**
     * <p>
     * The completion status of the model card export job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InProgress</code>: The model card export job is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code>: The model card export job is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
     * <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The completion status of the model card export job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InProgress</code>: The model card export job is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The model card export job is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
     *         <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
     *         </p>
     *         </li>
     * @see ModelCardExportJobStatus
     */
    public final ModelCardExportJobStatus status() {
        return ModelCardExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The completion status of the model card export job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InProgress</code>: The model card export job is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code>: The model card export job is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
     * <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The completion status of the model card export job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InProgress</code>: The model card export job is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The model card export job is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
     *         <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
     *         </p>
     *         </li>
     * @see ModelCardExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the model card that the model export job exports.
     * </p>
     * 
     * @return The name of the model card that the model export job exports.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The version of the model card that the model export job exports.
     * </p>
     * 
     * @return The version of the model card that the model export job exports.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * The export output details for the model card.
     * </p>
     * 
     * @return The export output details for the model card.
     */
    public final ModelCardExportOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The date and time that the model export job was created.
     * </p>
     * 
     * @return The date and time that the model export job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the model export job was last modified.
     * </p>
     * 
     * @return The date and time that the model export job was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The failure reason if the model export job fails.
     * </p>
     * 
     * @return The failure reason if the model export job fails.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The exported model card artifacts.
     * </p>
     * 
     * @return The exported model card artifacts.
     */
    public final ModelCardExportArtifacts exportArtifacts() {
        return exportArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(exportArtifacts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelCardExportJobResponse)) {
            return false;
        }
        DescribeModelCardExportJobResponse other = (DescribeModelCardExportJobResponse) obj;
        return Objects.equals(modelCardExportJobName(), other.modelCardExportJobName())
                && Objects.equals(modelCardExportJobArn(), other.modelCardExportJobArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(exportArtifacts(), other.exportArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelCardExportJobResponse").add("ModelCardExportJobName", modelCardExportJobName())
                .add("ModelCardExportJobArn", modelCardExportJobArn()).add("Status", statusAsString())
                .add("ModelCardName", modelCardName()).add("ModelCardVersion", modelCardVersion())
                .add("OutputConfig", outputConfig()).add("CreatedAt", createdAt()).add("LastModifiedAt", lastModifiedAt())
                .add("FailureReason", failureReason()).add("ExportArtifacts", exportArtifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardExportJobName":
            return Optional.ofNullable(clazz.cast(modelCardExportJobName()));
        case "ModelCardExportJobArn":
            return Optional.ofNullable(clazz.cast(modelCardExportJobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ExportArtifacts":
            return Optional.ofNullable(clazz.cast(exportArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelCardExportJobResponse, T> g) {
        return obj -> g.apply((DescribeModelCardExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelCardExportJobResponse> {
        /**
         * <p>
         * The name of the model card export job to describe.
         * </p>
         * 
         * @param modelCardExportJobName
         *        The name of the model card export job to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobName(String modelCardExportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model card export job.
         * </p>
         * 
         * @param modelCardExportJobArn
         *        The Amazon Resource Name (ARN) of the model card export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobArn(String modelCardExportJobArn);

        /**
         * <p>
         * The completion status of the model card export job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InProgress</code>: The model card export job is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code>: The model card export job is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
         * <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The completion status of the model card export job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InProgress</code>: The model card export job is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The model card export job is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
         *        <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
         *        </p>
         *        </li>
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The completion status of the model card export job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InProgress</code>: The model card export job is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code>: The model card export job is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
         * <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The completion status of the model card export job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InProgress</code>: The model card export job is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The model card export job is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the
         *        <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.
         *        </p>
         *        </li>
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder status(ModelCardExportJobStatus status);

        /**
         * <p>
         * The name of the model card that the model export job exports.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card that the model export job exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The version of the model card that the model export job exports.
         * </p>
         * 
         * @param modelCardVersion
         *        The version of the model card that the model export job exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * The export output details for the model card.
         * </p>
         * 
         * @param outputConfig
         *        The export output details for the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ModelCardExportOutputConfig outputConfig);

        /**
         * <p>
         * The export output details for the model card.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardExportOutputConfig.Builder}
         * avoiding the need to create one manually via {@link ModelCardExportOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardExportOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ModelCardExportOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ModelCardExportOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ModelCardExportOutputConfig)
         */
        default Builder outputConfig(Consumer<ModelCardExportOutputConfig.Builder> outputConfig) {
            return outputConfig(ModelCardExportOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The date and time that the model export job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the model export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the model export job was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time that the model export job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The failure reason if the model export job fails.
         * </p>
         * 
         * @param failureReason
         *        The failure reason if the model export job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The exported model card artifacts.
         * </p>
         * 
         * @param exportArtifacts
         *        The exported model card artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArtifacts(ModelCardExportArtifacts exportArtifacts);

        /**
         * <p>
         * The exported model card artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardExportArtifacts.Builder}
         * avoiding the need to create one manually via {@link ModelCardExportArtifacts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardExportArtifacts.Builder#build()} is called immediately
         * and its result is passed to {@link #exportArtifacts(ModelCardExportArtifacts)}.
         * 
         * @param exportArtifacts
         *        a consumer that will call methods on {@link ModelCardExportArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportArtifacts(ModelCardExportArtifacts)
         */
        default Builder exportArtifacts(Consumer<ModelCardExportArtifacts.Builder> exportArtifacts) {
            return exportArtifacts(ModelCardExportArtifacts.builder().applyMutation(exportArtifacts).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String modelCardExportJobName;

        private String modelCardExportJobArn;

        private String status;

        private String modelCardName;

        private Integer modelCardVersion;

        private ModelCardExportOutputConfig outputConfig;

        private Instant createdAt;

        private Instant lastModifiedAt;

        private String failureReason;

        private ModelCardExportArtifacts exportArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelCardExportJobResponse model) {
            super(model);
            modelCardExportJobName(model.modelCardExportJobName);
            modelCardExportJobArn(model.modelCardExportJobArn);
            status(model.status);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            outputConfig(model.outputConfig);
            createdAt(model.createdAt);
            lastModifiedAt(model.lastModifiedAt);
            failureReason(model.failureReason);
            exportArtifacts(model.exportArtifacts);
        }

        public final String getModelCardExportJobName() {
            return modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final String getModelCardExportJobArn() {
            return modelCardExportJobArn;
        }

        public final void setModelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
        }

        @Override
        public final Builder modelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCardExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final ModelCardExportOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ModelCardExportOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ModelCardExportOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ModelCardExportArtifacts.Builder getExportArtifacts() {
            return exportArtifacts != null ? exportArtifacts.toBuilder() : null;
        }

        public final void setExportArtifacts(ModelCardExportArtifacts.BuilderImpl exportArtifacts) {
            this.exportArtifacts = exportArtifacts != null ? exportArtifacts.build() : null;
        }

        @Override
        public final Builder exportArtifacts(ModelCardExportArtifacts exportArtifacts) {
            this.exportArtifacts = exportArtifacts;
            return this;
        }

        @Override
        public DescribeModelCardExportJobResponse build() {
            return new DescribeModelCardExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
