/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInferenceRecommendationsJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeInferenceRecommendationsJobResponse.Builder, DescribeInferenceRecommendationsJobResponse> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(DescribeInferenceRecommendationsJobResponse::jobName))
            .setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDescription").getter(getter(DescribeInferenceRecommendationsJobResponse::jobDescription))
            .setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(DescribeInferenceRecommendationsJobResponse::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobArn")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeInferenceRecommendationsJobResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeInferenceRecommendationsJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(DescribeInferenceRecommendationsJobResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeInferenceRecommendationsJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeInferenceRecommendationsJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<RecommendationJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<RecommendationJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(RecommendationJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<RecommendationJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField
            .<RecommendationJobStoppingConditions> builder(MarshallingType.SDK_POJO).memberName("StoppingConditions")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::stoppingConditions))
            .setter(setter(Builder::stoppingConditions)).constructor(RecommendationJobStoppingConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build())
            .build();

    private static final SdkField<List<InferenceRecommendation>> INFERENCE_RECOMMENDATIONS_FIELD = SdkField
            .<List<InferenceRecommendation>> builder(MarshallingType.LIST)
            .memberName("InferenceRecommendations")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::inferenceRecommendations))
            .setter(setter(Builder::inferenceRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EndpointPerformance>> ENDPOINT_PERFORMANCES_FIELD = SdkField
            .<List<EndpointPerformance>> builder(MarshallingType.LIST)
            .memberName("EndpointPerformances")
            .getter(getter(DescribeInferenceRecommendationsJobResponse::endpointPerformances))
            .setter(setter(Builder::endpointPerformances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPerformances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointPerformance> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointPerformance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_DESCRIPTION_FIELD, JOB_TYPE_FIELD, JOB_ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            COMPLETION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, INPUT_CONFIG_FIELD, STOPPING_CONDITIONS_FIELD,
            INFERENCE_RECOMMENDATIONS_FIELD, ENDPOINT_PERFORMANCES_FIELD));

    private final String jobName;

    private final String jobDescription;

    private final String jobType;

    private final String jobArn;

    private final String roleArn;

    private final String status;

    private final Instant creationTime;

    private final Instant completionTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final RecommendationJobInputConfig inputConfig;

    private final RecommendationJobStoppingConditions stoppingConditions;

    private final List<InferenceRecommendation> inferenceRecommendations;

    private final List<EndpointPerformance> endpointPerformances;

    private DescribeInferenceRecommendationsJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.jobType = builder.jobType;
        this.jobArn = builder.jobArn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.inputConfig = builder.inputConfig;
        this.stoppingConditions = builder.stoppingConditions;
        this.inferenceRecommendations = builder.inferenceRecommendations;
        this.endpointPerformances = builder.endpointPerformances;
    }

    /**
     * <p>
     * The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services
     * account.
     * </p>
     * 
     * @return The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web
     *         Services account.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job description that you provided when you initiated the job.
     * </p>
     * 
     * @return The job description that you provided when you initiated the job.
     */
    public final String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * The job type that you provided when you initiated the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type that you provided when you initiated the job.
     * @see RecommendationJobType
     */
    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(jobType);
    }

    /**
     * <p>
     * The job type that you provided when you initiated the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type that you provided when you initiated the job.
     * @see RecommendationJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided
     * when you initiated the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you
     *         provided when you initiated the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see RecommendationJobStatus
     */
    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see RecommendationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that shows when the job was created.
     * </p>
     * 
     * @return A timestamp that shows when the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job completed.
     * </p>
     * 
     * @return A timestamp that shows when the job completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job was last modified.
     * </p>
     * 
     * @return A timestamp that shows when the job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If the job fails, provides information why the job failed.
     * </p>
     * 
     * @return If the job fails, provides information why the job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
     * endpoint configurations you provided when you initiated the job.
     * </p>
     * 
     * @return Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern,
     *         and endpoint configurations you provided when you initiated the job.
     */
    public final RecommendationJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * The stopping conditions that you provided when you initiated the job.
     * </p>
     * 
     * @return The stopping conditions that you provided when you initiated the job.
     */
    public final RecommendationJobStoppingConditions stoppingConditions() {
        return stoppingConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceRecommendations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceRecommendations() {
        return inferenceRecommendations != null && !(inferenceRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations made by Inference Recommender.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceRecommendations} method.
     * </p>
     * 
     * @return The recommendations made by Inference Recommender.
     */
    public final List<InferenceRecommendation> inferenceRecommendations() {
        return inferenceRecommendations;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointPerformances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointPerformances() {
        return endpointPerformances != null && !(endpointPerformances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The performance results from running an Inference Recommender job on an existing endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointPerformances} method.
     * </p>
     * 
     * @return The performance results from running an Inference Recommender job on an existing endpoint.
     */
    public final List<EndpointPerformance> endpointPerformances() {
        return endpointPerformances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceRecommendations() ? inferenceRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointPerformances() ? endpointPerformances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceRecommendationsJobResponse)) {
            return false;
        }
        DescribeInferenceRecommendationsJobResponse other = (DescribeInferenceRecommendationsJobResponse) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(inputConfig(), other.inputConfig())
                && Objects.equals(stoppingConditions(), other.stoppingConditions())
                && hasInferenceRecommendations() == other.hasInferenceRecommendations()
                && Objects.equals(inferenceRecommendations(), other.inferenceRecommendations())
                && hasEndpointPerformances() == other.hasEndpointPerformances()
                && Objects.equals(endpointPerformances(), other.endpointPerformances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInferenceRecommendationsJobResponse").add("JobName", jobName())
                .add("JobDescription", jobDescription()).add("JobType", jobTypeAsString()).add("JobArn", jobArn())
                .add("RoleArn", roleArn()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("CompletionTime", completionTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason()).add("InputConfig", inputConfig())
                .add("StoppingConditions", stoppingConditions())
                .add("InferenceRecommendations", hasInferenceRecommendations() ? inferenceRecommendations() : null)
                .add("EndpointPerformances", hasEndpointPerformances() ? endpointPerformances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "JobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "StoppingConditions":
            return Optional.ofNullable(clazz.cast(stoppingConditions()));
        case "InferenceRecommendations":
            return Optional.ofNullable(clazz.cast(inferenceRecommendations()));
        case "EndpointPerformances":
            return Optional.ofNullable(clazz.cast(endpointPerformances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceRecommendationsJobResponse, T> g) {
        return obj -> g.apply((DescribeInferenceRecommendationsJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInferenceRecommendationsJobResponse> {
        /**
         * <p>
         * The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services
         * account.
         * </p>
         * 
         * @param jobName
         *        The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job description that you provided when you initiated the job.
         * </p>
         * 
         * @param jobDescription
         *        The job description that you provided when you initiated the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * The job type that you provided when you initiated the job.
         * </p>
         * 
         * @param jobType
         *        The job type that you provided when you initiated the job.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The job type that you provided when you initiated the job.
         * </p>
         * 
         * @param jobType
         *        The job type that you provided when you initiated the job.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(RecommendationJobType jobType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you
         * provided when you initiated the job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role
         *        you provided when you initiated the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(RecommendationJobStatus status);

        /**
         * <p>
         * A timestamp that shows when the job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the job completed.
         * </p>
         * 
         * @param completionTime
         *        A timestamp that shows when the job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * A timestamp that shows when the job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that shows when the job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If the job fails, provides information why the job failed.
         * </p>
         * 
         * @param failureReason
         *        If the job fails, provides information why the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
         * endpoint configurations you provided when you initiated the job.
         * </p>
         * 
         * @param inputConfig
         *        Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern,
         *        and endpoint configurations you provided when you initiated the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(RecommendationJobInputConfig inputConfig);

        /**
         * <p>
         * Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and
         * endpoint configurations you provided when you initiated the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationJobInputConfig.Builder}
         * avoiding the need to create one manually via {@link RecommendationJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(RecommendationJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link RecommendationJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(RecommendationJobInputConfig)
         */
        default Builder inputConfig(Consumer<RecommendationJobInputConfig.Builder> inputConfig) {
            return inputConfig(RecommendationJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * The stopping conditions that you provided when you initiated the job.
         * </p>
         * 
         * @param stoppingConditions
         *        The stopping conditions that you provided when you initiated the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions);

        /**
         * <p>
         * The stopping conditions that you provided when you initiated the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationJobStoppingConditions.Builder} avoiding the need to create one manually via
         * {@link RecommendationJobStoppingConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobStoppingConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingConditions(RecommendationJobStoppingConditions)}.
         * 
         * @param stoppingConditions
         *        a consumer that will call methods on {@link RecommendationJobStoppingConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingConditions(RecommendationJobStoppingConditions)
         */
        default Builder stoppingConditions(Consumer<RecommendationJobStoppingConditions.Builder> stoppingConditions) {
            return stoppingConditions(RecommendationJobStoppingConditions.builder().applyMutation(stoppingConditions).build());
        }

        /**
         * <p>
         * The recommendations made by Inference Recommender.
         * </p>
         * 
         * @param inferenceRecommendations
         *        The recommendations made by Inference Recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceRecommendations(Collection<InferenceRecommendation> inferenceRecommendations);

        /**
         * <p>
         * The recommendations made by Inference Recommender.
         * </p>
         * 
         * @param inferenceRecommendations
         *        The recommendations made by Inference Recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceRecommendations(InferenceRecommendation... inferenceRecommendations);

        /**
         * <p>
         * The recommendations made by Inference Recommender.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceRecommendations(List<InferenceRecommendation>)}.
         * 
         * @param inferenceRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceRecommendations(java.util.Collection<InferenceRecommendation>)
         */
        Builder inferenceRecommendations(Consumer<InferenceRecommendation.Builder>... inferenceRecommendations);

        /**
         * <p>
         * The performance results from running an Inference Recommender job on an existing endpoint.
         * </p>
         * 
         * @param endpointPerformances
         *        The performance results from running an Inference Recommender job on an existing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPerformances(Collection<EndpointPerformance> endpointPerformances);

        /**
         * <p>
         * The performance results from running an Inference Recommender job on an existing endpoint.
         * </p>
         * 
         * @param endpointPerformances
         *        The performance results from running an Inference Recommender job on an existing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPerformances(EndpointPerformance... endpointPerformances);

        /**
         * <p>
         * The performance results from running an Inference Recommender job on an existing endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.EndpointPerformance.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.EndpointPerformance#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.EndpointPerformance.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointPerformances(List<EndpointPerformance>)}.
         * 
         * @param endpointPerformances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.EndpointPerformance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointPerformances(java.util.Collection<EndpointPerformance>)
         */
        Builder endpointPerformances(Consumer<EndpointPerformance.Builder>... endpointPerformances);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String jobName;

        private String jobDescription;

        private String jobType;

        private String jobArn;

        private String roleArn;

        private String status;

        private Instant creationTime;

        private Instant completionTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private RecommendationJobInputConfig inputConfig;

        private RecommendationJobStoppingConditions stoppingConditions;

        private List<InferenceRecommendation> inferenceRecommendations = DefaultSdkAutoConstructList.getInstance();

        private List<EndpointPerformance> endpointPerformances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceRecommendationsJobResponse model) {
            super(model);
            jobName(model.jobName);
            jobDescription(model.jobDescription);
            jobType(model.jobType);
            jobArn(model.jobArn);
            roleArn(model.roleArn);
            status(model.status);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            inputConfig(model.inputConfig);
            stoppingConditions(model.stoppingConditions);
            inferenceRecommendations(model.inferenceRecommendations);
            endpointPerformances(model.endpointPerformances);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RecommendationJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(RecommendationJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(RecommendationJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final RecommendationJobStoppingConditions.Builder getStoppingConditions() {
            return stoppingConditions != null ? stoppingConditions.toBuilder() : null;
        }

        public final void setStoppingConditions(RecommendationJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        @Override
        public final Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final List<InferenceRecommendation.Builder> getInferenceRecommendations() {
            List<InferenceRecommendation.Builder> result = InferenceRecommendationsCopier
                    .copyToBuilder(this.inferenceRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceRecommendations(Collection<InferenceRecommendation.BuilderImpl> inferenceRecommendations) {
            this.inferenceRecommendations = InferenceRecommendationsCopier.copyFromBuilder(inferenceRecommendations);
        }

        @Override
        public final Builder inferenceRecommendations(Collection<InferenceRecommendation> inferenceRecommendations) {
            this.inferenceRecommendations = InferenceRecommendationsCopier.copy(inferenceRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendations(InferenceRecommendation... inferenceRecommendations) {
            inferenceRecommendations(Arrays.asList(inferenceRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendations(Consumer<InferenceRecommendation.Builder>... inferenceRecommendations) {
            inferenceRecommendations(Stream.of(inferenceRecommendations)
                    .map(c -> InferenceRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EndpointPerformance.Builder> getEndpointPerformances() {
            List<EndpointPerformance.Builder> result = EndpointPerformancesCopier.copyToBuilder(this.endpointPerformances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointPerformances(Collection<EndpointPerformance.BuilderImpl> endpointPerformances) {
            this.endpointPerformances = EndpointPerformancesCopier.copyFromBuilder(endpointPerformances);
        }

        @Override
        public final Builder endpointPerformances(Collection<EndpointPerformance> endpointPerformances) {
            this.endpointPerformances = EndpointPerformancesCopier.copy(endpointPerformances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPerformances(EndpointPerformance... endpointPerformances) {
            endpointPerformances(Arrays.asList(endpointPerformances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPerformances(Consumer<EndpointPerformance.Builder>... endpointPerformances) {
            endpointPerformances(Stream.of(endpointPerformances).map(c -> EndpointPerformance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInferenceRecommendationsJobResponse build() {
            return new DescribeInferenceRecommendationsJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
