/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStudioLifecycleConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateStudioLifecycleConfigResponse.Builder, CreateStudioLifecycleConfigResponse> {
    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigArn").getter(getter(CreateStudioLifecycleConfigResponse::studioLifecycleConfigArn))
            .setter(setter(Builder::studioLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STUDIO_LIFECYCLE_CONFIG_ARN_FIELD));

    private final String studioLifecycleConfigArn;

    private CreateStudioLifecycleConfigResponse(BuilderImpl builder) {
        super(builder);
        this.studioLifecycleConfigArn = builder.studioLifecycleConfigArn;
    }

    /**
     * <p>
     * The ARN of your created Lifecycle Configuration.
     * </p>
     * 
     * @return The ARN of your created Lifecycle Configuration.
     */
    public final String studioLifecycleConfigArn() {
        return studioLifecycleConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioLifecycleConfigResponse)) {
            return false;
        }
        CreateStudioLifecycleConfigResponse other = (CreateStudioLifecycleConfigResponse) obj;
        return Objects.equals(studioLifecycleConfigArn(), other.studioLifecycleConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStudioLifecycleConfigResponse")
                .add("StudioLifecycleConfigArn", studioLifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioLifecycleConfigResponse, T> g) {
        return obj -> g.apply((CreateStudioLifecycleConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStudioLifecycleConfigResponse> {
        /**
         * <p>
         * The ARN of your created Lifecycle Configuration.
         * </p>
         * 
         * @param studioLifecycleConfigArn
         *        The ARN of your created Lifecycle Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigArn(String studioLifecycleConfigArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String studioLifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioLifecycleConfigResponse model) {
            super(model);
            studioLifecycleConfigArn(model.studioLifecycleConfigArn);
        }

        public final String getStudioLifecycleConfigArn() {
            return studioLifecycleConfigArn;
        }

        public final void setStudioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
        }

        @Override
        public final Builder studioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
            return this;
        }

        @Override
        public CreateStudioLifecycleConfigResponse build() {
            return new CreateStudioLifecycleConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
