/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;

public class ListRegionalBucketsIterable
implements SdkIterable<ListRegionalBucketsResponse> {
    private final S3ControlClient client;
    private final ListRegionalBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRegionalBucketsIterable(S3ControlClient client, ListRegionalBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRegionalBucketsResponseFetcher();
    }

    public Iterator<ListRegionalBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRegionalBucketsResponseFetcher
    implements SyncPageFetcher<ListRegionalBucketsResponse> {
        private ListRegionalBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListRegionalBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRegionalBucketsResponse nextPage(ListRegionalBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListRegionalBucketsIterable.this.client.listRegionalBuckets(ListRegionalBucketsIterable.this.firstRequest);
            }
            return ListRegionalBucketsIterable.this.client.listRegionalBuckets((ListRegionalBucketsRequest)((Object)ListRegionalBucketsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

