/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.NetworkOrigin;
import software.amazon.awssdk.services.s3control.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AccessPoint.getter(AccessPoint::name)).setter(AccessPoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkOrigin").getter(AccessPoint.getter(AccessPoint::networkOriginAsString)).setter(AccessPoint.setter(Builder::networkOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin").unmarshallLocationName("NetworkOrigin").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(AccessPoint.getter(AccessPoint::vpcConfiguration)).setter(AccessPoint.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").unmarshallLocationName("VpcConfiguration").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(AccessPoint.getter(AccessPoint::bucket)).setter(AccessPoint.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(AccessPoint.getter(AccessPoint::accessPointArn)).setter(AccessPoint.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").unmarshallLocationName("AccessPointArn").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(AccessPoint.getter(AccessPoint::alias)).setter(AccessPoint.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").unmarshallLocationName("Alias").build()}).build();
    private static final SdkField<String> BUCKET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketAccountId").getter(AccessPoint.getter(AccessPoint::bucketAccountId)).setter(AccessPoint.setter(Builder::bucketAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccountId").unmarshallLocationName("BucketAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NETWORK_ORIGIN_FIELD, VPC_CONFIGURATION_FIELD, BUCKET_FIELD, ACCESS_POINT_ARN_FIELD, ALIAS_FIELD, BUCKET_ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String networkOrigin;
    private final VpcConfiguration vpcConfiguration;
    private final String bucket;
    private final String accessPointArn;
    private final String alias;
    private final String bucketAccountId;

    private AccessPoint(BuilderImpl builder) {
        this.name = builder.name;
        this.networkOrigin = builder.networkOrigin;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.bucket = builder.bucket;
        this.accessPointArn = builder.accessPointArn;
        this.alias = builder.alias;
        this.bucketAccountId = builder.bucketAccountId;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkOrigin networkOrigin() {
        return NetworkOrigin.fromValue(this.networkOrigin);
    }

    public final String networkOriginAsString() {
        return this.networkOrigin;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final String alias() {
        return this.alias;
    }

    public final String bucketAccountId() {
        return this.bucketAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPoint)) {
            return false;
        }
        AccessPoint other = (AccessPoint)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.networkOriginAsString(), other.networkOriginAsString()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.accessPointArn(), other.accessPointArn()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.bucketAccountId(), other.bucketAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPoint").add("Name", (Object)this.name()).add("NetworkOrigin", (Object)this.networkOriginAsString()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("Bucket", (Object)this.bucket()).add("AccessPointArn", (Object)this.accessPointArn()).add("Alias", (Object)this.alias()).add("BucketAccountId", (Object)this.bucketAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkOrigin": {
                return Optional.ofNullable(clazz.cast(this.networkOriginAsString()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "BucketAccountId": {
                return Optional.ofNullable(clazz.cast(this.bucketAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPoint, T> g) {
        return obj -> g.apply((AccessPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String networkOrigin;
        private VpcConfiguration vpcConfiguration;
        private String bucket;
        private String accessPointArn;
        private String alias;
        private String bucketAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPoint model) {
            this.name(model.name);
            this.networkOrigin(model.networkOrigin);
            this.vpcConfiguration(model.vpcConfiguration);
            this.bucket(model.bucket);
            this.accessPointArn(model.accessPointArn);
            this.alias(model.alias);
            this.bucketAccountId(model.bucketAccountId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkOrigin() {
            return this.networkOrigin;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        @Override
        public final Builder networkOrigin(NetworkOrigin networkOrigin) {
            this.networkOrigin(networkOrigin == null ? null : networkOrigin.toString());
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getBucketAccountId() {
            return this.bucketAccountId;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public AccessPoint build() {
            return new AccessPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPoint> {
        public Builder name(String var1);

        public Builder networkOrigin(String var1);

        public Builder networkOrigin(NetworkOrigin var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder bucket(String var1);

        public Builder accessPointArn(String var1);

        public Builder alias(String var1);

        public Builder bucketAccountId(String var1);
    }
}

