/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StorageLensTagsCopier {
    static List<StorageLensTag> copy(Collection<? extends StorageLensTag> storageLensTagsParam) {
        List<StorageLensTag> list;
        if (storageLensTagsParam == null || storageLensTagsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StorageLensTag> modifiableList = new ArrayList<>();
            storageLensTagsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StorageLensTag> copyFromBuilder(Collection<? extends StorageLensTag.Builder> storageLensTagsParam) {
        List<StorageLensTag> list;
        if (storageLensTagsParam == null || storageLensTagsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StorageLensTag> modifiableList = new ArrayList<>();
            storageLensTagsParam.forEach(entry -> {
                StorageLensTag member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StorageLensTag.Builder> copyToBuilder(Collection<? extends StorageLensTag> storageLensTagsParam) {
        List<StorageLensTag.Builder> list;
        if (storageLensTagsParam == null || storageLensTagsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StorageLensTag.Builder> modifiableList = new ArrayList<>();
            storageLensTagsParam.forEach(entry -> {
                StorageLensTag.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
