/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;

public class ListAccessPointsPublisher
implements SdkPublisher<ListAccessPointsResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPointsPublisher(S3ControlAsyncClient client, ListAccessPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPointsPublisher(S3ControlAsyncClient client, ListAccessPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessPointsResponseFetcher
    implements AsyncPageFetcher<ListAccessPointsResponse> {
        private ListAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPointsResponse> nextPage(ListAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsPublisher.this.client.listAccessPoints(ListAccessPointsPublisher.this.firstRequest);
            }
            return ListAccessPointsPublisher.this.client.listAccessPoints((ListAccessPointsRequest)((Object)ListAccessPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

