/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.S3Grant;
import software.amazon.awssdk.services.s3control.model.S3GrantListCopier;
import software.amazon.awssdk.services.s3control.model.S3ObjectOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3AccessControlList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3AccessControlList> {
    private static final SdkField<S3ObjectOwner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Owner").getter(S3AccessControlList.getter(S3AccessControlList::owner)).setter(S3AccessControlList.setter(Builder::owner)).constructor(S3ObjectOwner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build();
    private static final SdkField<List<S3Grant>> GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Grants").getter(S3AccessControlList.getter(S3AccessControlList::grants)).setter(S3AccessControlList.setter(Builder::grants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grants").unmarshallLocationName("Grants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Grant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD, GRANTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3ObjectOwner owner;
    private final List<S3Grant> grants;

    private S3AccessControlList(BuilderImpl builder) {
        this.owner = builder.owner;
        this.grants = builder.grants;
    }

    public final S3ObjectOwner owner() {
        return this.owner;
    }

    public final boolean hasGrants() {
        return this.grants != null && !(this.grants instanceof SdkAutoConstructList);
    }

    public final List<S3Grant> grants() {
        return this.grants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrants() ? this.grants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessControlList)) {
            return false;
        }
        S3AccessControlList other = (S3AccessControlList)obj;
        return Objects.equals(this.owner(), other.owner()) && this.hasGrants() == other.hasGrants() && Objects.equals(this.grants(), other.grants());
    }

    public final String toString() {
        return ToString.builder((String)"S3AccessControlList").add("Owner", (Object)this.owner()).add("Grants", this.hasGrants() ? this.grants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Grants": {
                return Optional.ofNullable(clazz.cast(this.grants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3AccessControlList, T> g) {
        return obj -> g.apply((S3AccessControlList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3ObjectOwner owner;
        private List<S3Grant> grants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessControlList model) {
            this.owner(model.owner);
            this.grants(model.grants);
        }

        public final S3ObjectOwner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        public final void setOwner(S3ObjectOwner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(S3ObjectOwner owner) {
            this.owner = owner;
            return this;
        }

        public final List<S3Grant.Builder> getGrants() {
            List<S3Grant.Builder> result = S3GrantListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrants(Collection<S3Grant.BuilderImpl> grants) {
            this.grants = S3GrantListCopier.copyFromBuilder(grants);
        }

        @Override
        public final Builder grants(Collection<S3Grant> grants) {
            this.grants = S3GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(S3Grant ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<S3Grant.Builder> ... grants) {
            this.grants(Stream.of(grants).map(c -> (S3Grant)((S3Grant.Builder)S3Grant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3AccessControlList build() {
            return new S3AccessControlList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3AccessControlList> {
        public Builder owner(S3ObjectOwner var1);

        default public Builder owner(Consumer<S3ObjectOwner.Builder> owner) {
            return this.owner((S3ObjectOwner)((S3ObjectOwner.Builder)S3ObjectOwner.builder().applyMutation(owner)).build());
        }

        public Builder grants(Collection<S3Grant> var1);

        public Builder grants(S3Grant ... var1);

        public Builder grants(Consumer<S3Grant.Builder> ... var1);
    }
}

