/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.arns.ArnResource;
import software.amazon.awssdk.services.s3.internal.resource.ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.IntermediateOutpostResource;
import software.amazon.awssdk.services.s3.internal.resource.OutpostResourceType;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnUtils;
import software.amazon.awssdk.services.s3.internal.resource.S3OutpostResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3control.S3ControlBucketResource;
import software.amazon.awssdk.services.s3control.internal.S3ControlResourceType;

@SdkInternalApi
public final class S3ControlArnConverter
implements ArnConverter<S3Resource> {
    private static final S3ControlArnConverter INSTANCE = new S3ControlArnConverter();

    private S3ControlArnConverter() {
    }

    public static S3ControlArnConverter getInstance() {
        return INSTANCE;
    }

    public S3Resource convertArn(Arn arn) {
        S3ControlResourceType s3ResourceType;
        try {
            s3ResourceType = arn.resource().resourceType().map(S3ControlResourceType::fromValue).orElseThrow(() -> new IllegalArgumentException("resource type cannot be null"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown ARN type '" + arn.resource().resourceType() + "'");
        }
        switch (s3ResourceType) {
            case OUTPOST: {
                return this.parseS3OutpostArn(arn);
            }
        }
        throw new IllegalArgumentException("Unknown ARN type '" + arn.resource().resourceType() + "'");
    }

    private S3Resource parseS3OutpostArn(Arn arn) {
        OutpostResourceType outpostResourceType;
        IntermediateOutpostResource intermediateOutpostResource = S3ArnUtils.parseOutpostArn((Arn)arn);
        ArnResource outpostSubresource = intermediateOutpostResource.outpostSubresource();
        String subResource = outpostSubresource.resource();
        try {
            outpostResourceType = outpostSubresource.resourceType().map(OutpostResourceType::fromValue).orElseThrow(() -> new IllegalArgumentException("resource type cannot be null"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown outpost ARN type '" + outpostSubresource.resourceType() + "'");
        }
        String outpostId = intermediateOutpostResource.outpostId();
        switch (outpostResourceType) {
            case OUTPOST_BUCKET: {
                return S3ControlBucketResource.builder().bucketName(subResource).parentS3Resource((S3Resource)S3OutpostResource.builder().partition(arn.partition()).region((String)arn.region().orElse(null)).accountId((String)arn.accountId().orElse(null)).outpostId(outpostId).build()).build();
            }
            case OUTPOST_ACCESS_POINT: {
                return S3AccessPointResource.builder().accessPointName(subResource).parentS3Resource((S3Resource)S3OutpostResource.builder().partition(arn.partition()).region((String)arn.region().orElse(null)).accountId((String)arn.accountId().orElse(null)).outpostId(outpostId).build()).build();
            }
        }
        throw new IllegalArgumentException("Unknown outpost ARN type '" + outpostSubresource.resourceType() + "'");
    }
}

