/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSuggestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSuggestion> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainSuggestion.getter(DomainSuggestion::domainName)).setter(DomainSuggestion.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Availability").getter(DomainSuggestion.getter(DomainSuggestion::availability)).setter(DomainSuggestion.setter(Builder::availability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Availability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, AVAILABILITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String availability;

    private DomainSuggestion(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.availability = builder.availability;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String availability() {
        return this.availability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availability());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSuggestion)) {
            return false;
        }
        DomainSuggestion other = (DomainSuggestion)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.availability(), other.availability());
    }

    public final String toString() {
        return ToString.builder((String)"DomainSuggestion").add("DomainName", (Object)this.domainName()).add("Availability", (Object)this.availability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Availability": {
                return Optional.ofNullable(clazz.cast(this.availability()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSuggestion, T> g) {
        return obj -> g.apply((DomainSuggestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSuggestion model) {
            this.domainName(model.domainName);
            this.availability(model.availability);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAvailability() {
            return this.availability;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        public DomainSuggestion build() {
            return new DomainSuggestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSuggestion> {
        public Builder domainName(String var1);

        public Builder availability(String var1);
    }
}

