/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VPCRegion {
    US_EAST_1("us-east-1"),
    US_EAST_2("us-east-2"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    EU_WEST_1("eu-west-1"),
    EU_WEST_2("eu-west-2"),
    EU_WEST_3("eu-west-3"),
    EU_CENTRAL_1("eu-central-1"),
    EU_CENTRAL_2("eu-central-2"),
    AP_EAST_1("ap-east-1"),
    ME_SOUTH_1("me-south-1"),
    US_GOV_WEST_1("us-gov-west-1"),
    US_GOV_EAST_1("us-gov-east-1"),
    US_ISO_EAST_1("us-iso-east-1"),
    US_ISO_WEST_1("us-iso-west-1"),
    US_ISOB_EAST_1("us-isob-east-1"),
    ME_CENTRAL_1("me-central-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_SOUTHEAST_3("ap-southeast-3"),
    AP_SOUTH_1("ap-south-1"),
    AP_SOUTH_2("ap-south-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    AP_NORTHEAST_2("ap-northeast-2"),
    AP_NORTHEAST_3("ap-northeast-3"),
    EU_NORTH_1("eu-north-1"),
    SA_EAST_1("sa-east-1"),
    CA_CENTRAL_1("ca-central-1"),
    CN_NORTH_1("cn-north-1"),
    AF_SOUTH_1("af-south-1"),
    EU_SOUTH_1("eu-south-1"),
    EU_SOUTH_2("eu-south-2"),
    AP_SOUTHEAST_4("ap-southeast-4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VPCRegion> VALUE_MAP;
    private final String value;

    private VPCRegion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VPCRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VPCRegion> knownValues() {
        EnumSet<VPCRegion> knownValues = EnumSet.allOf(VPCRegion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VPCRegion.class, VPCRegion::toString);
    }
}

