/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SimulationJobStatus {
    PENDING("Pending"),
    PREPARING("Preparing"),
    RUNNING("Running"),
    RESTARTING("Restarting"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    RUNNING_FAILED("RunningFailed"),
    TERMINATING("Terminating"),
    TERMINATED("Terminated"),
    CANCELED("Canceled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SimulationJobStatus> VALUE_MAP;
    private final String value;

    private SimulationJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SimulationJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SimulationJobStatus> knownValues() {
        EnumSet<SimulationJobStatus> knownValues = EnumSet.allOf(SimulationJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SimulationJobStatus.class, SimulationJobStatus::toString);
    }
}

