/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorldExportJobStatus {
    PENDING("Pending"),
    RUNNING("Running"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    CANCELING("Canceling"),
    CANCELED("Canceled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorldExportJobStatus> VALUE_MAP;
    private final String value;

    private WorldExportJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorldExportJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorldExportJobStatus> knownValues() {
        EnumSet<WorldExportJobStatus> knownValues = EnumSet.allOf(WorldExportJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorldExportJobStatus.class, WorldExportJobStatus::toString);
    }
}

